package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.dao.BcmTbBudgetsubFmisMapper;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.task.api.BcmBudgetSyncTaskService;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 类名： BcmBudgetSyncTaskServiceImpl
 * 说明：预算科目同步比对任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/15 12:49
 */
@HTServiceImpl
public class BcmBudgetSyncTaskServiceImpl implements BcmBudgetSyncTaskService {

    @Autowired
    private BcmTbBudgetsubFmisMapper bcmTbBudgetsubFmisMapper;

    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    private static final Integer delPage = 1;

    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;

    private static final Long defaultUserId = 1L;

    private static final String defaultUserName = "系统管理员";

    @Override
    public void syncBudgetProject() {
        // 默认查第一页
        int pageNo = delPage;
        // 循环、分页查询TB_BUDGETSUB_FMIS表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
        BcmTbBudgetsubFmisPO qryPO = new BcmTbBudgetsubFmisPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        while (true) {
            Page<BcmTbBudgetsubFmisPO> page = new Page<>(pageNo,dealCount);
            List<BcmTbBudgetsubFmisPO> pageList = bcmTbBudgetsubFmisMapper.getPageList(qryPO, page);
            if (ObjectUtil.isEmpty(pageList)) {
                return;
            }
            // 根据TB_BUDGETSUB_FMIS的PK_OBJ去查询bcm_budget_project_info的PROJECT_ID（批量查询）
            List<String> projectIdList = pageList.stream().map(BcmTbBudgetsubFmisPO::getPkObj).collect(Collectors.toList());
            BcmQueryBudgetProjectInfoPO qryProjectPO = new BcmQueryBudgetProjectInfoPO();
            qryProjectPO.setProjectIdList(projectIdList);
            qryProjectPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            List<BcmBudgetProjectInfoPO> projectInfoPOS = bcmBudgetProjectInfoMapper.getList(qryProjectPO);
            // 新增的集合
            List<BcmBudgetProjectInfoPO> batchInsertPOList = new ArrayList<>();
            // 判断预算项目是否为空,如果不为空则存在更新数据，
            if (ObjectUtil.isNotEmpty(projectInfoPOS)) {
                // 拿到更新的集合
                List<String> updateProjectIds = projectInfoPOS.stream().map(BcmBudgetProjectInfoPO::getProjectId).collect(Collectors.toList());
                Map<String, BcmBudgetProjectInfoPO> updateMap = projectInfoPOS.stream().collect(Collectors.toMap(BcmBudgetProjectInfoPO::getProjectId, Function.identity()));
                // 更新临时表的集合
                // 做更新操作
                for (BcmTbBudgetsubFmisPO item : pageList) {
                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.ENABLE);
                    } else {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    if (!updateProjectIds.contains(item.getPkObj())) { //新增
                        // 查询机构信息
                        BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                        if (ObjectUtil.isEmpty(nowOrgPO)) {
                            item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                            continue;
                        }
                        // 入参组装
                        BcmBudgetProjectInfoPO insertPO = new BcmBudgetProjectInfoPO();
                        insertPO.setId(BcmIdUtil.nextId());
                        insertPO.setProjectId(item.getPkObj());
                        insertPO.setProjectCode(item.getObjcode());
                        insertPO.setProjectName(item.getObjname());
                        insertPO.setStatus(item.getEnablestate());
                        insertPO.setFinancialOrgId(nowOrgPO.getPkOrg());
                        insertPO.setFinancialOrgCode(nowOrgPO.getCode());
                        insertPO.setFinancialOrgName(nowOrgPO.getName());
                        insertPO.setCreateUserId(defaultUserId);
                        insertPO.setCreateUserName(defaultUserName);
                        insertPO.setCreateTime(new Date());
                        insertPO.setUpdateUserId(defaultUserId);
                        insertPO.setUpdateUserName(defaultUserName);
                        insertPO.setUpdateTime(new Date());
                        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                        batchInsertPOList.add(insertPO);
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                        continue;
                    }
                    BcmBudgetProjectInfoPO sourcePO = updateMap.get(item.getPkObj());
                    BcmBudgetProjectInfoPO setPO = new BcmBudgetProjectInfoPO();
                    // 判断是否有字段变更
                    if (!item.getObjname().equals(sourcePO.getProjectName())) {
                        setPO.setProjectName(item.getObjname());
                    }
                    if (!item.getObjcode().equals(sourcePO.getProjectCode())) {
                        setPO.setProjectCode(item.getObjcode());
                    }
                    if (!item.getEnablestate().equals(sourcePO.getStatus())) {
                        setPO.setStatus(item.getEnablestate());
                    }
                    if (!item.getPkOrg().equals(sourcePO.getFinancialOrgId())) {
                        // 查询之后更改值
                        BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                        if (ObjectUtil.isEmpty(nowOrgPO)) {
                            item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                            continue;
                        }
                        setPO.setFinancialOrgId(nowOrgPO.getPkOrg());
                        setPO.setFinancialOrgCode(nowOrgPO.getCode());
                        setPO.setFinancialOrgName(nowOrgPO.getName());
                    }
                    // 如果有值变更,
                    if (ObjectUtil.isNotEmpty(setPO.getProjectCode())
                            || ObjectUtil.isNotEmpty(setPO.getProjectName())
                            || ObjectUtil.isNotEmpty(setPO.getStatus())
                            || ObjectUtil.isNotEmpty(setPO.getFinancialOrgId())) {
                        setPO.setUpdateUserId(defaultUserId);
                        setPO.setUpdateUserName(defaultUserName);
                        setPO.setUpdateTime(new Date());
                        BcmBudgetProjectInfoPO wherePO = new BcmBudgetProjectInfoPO();
                        wherePO.setId(sourcePO.getId());
                        bcmBudgetProjectInfoMapper.updateBy(setPO,wherePO);
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                    } else {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                    }
                }
            } else {
                for (BcmTbBudgetsubFmisPO item : pageList) {
                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.ENABLE);
                    } else {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    // 查询机构信息
                    BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty(nowOrgPO)) {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }
                    // 入参组装
                    BcmBudgetProjectInfoPO insertPO = new BcmBudgetProjectInfoPO();
                    insertPO.setId(BcmIdUtil.nextId());
                    insertPO.setProjectId(item.getPkObj());
                    insertPO.setProjectCode(item.getObjcode());
                    insertPO.setProjectName(item.getObjname());
                    insertPO.setStatus(item.getEnablestate());
                    insertPO.setFinancialOrgId(nowOrgPO.getPkOrg());
                    insertPO.setFinancialOrgCode(nowOrgPO.getCode());
                    insertPO.setFinancialOrgName(nowOrgPO.getName());
                    insertPO.setCreateUserId(defaultUserId);
                    insertPO.setCreateUserName(defaultUserName);
                    insertPO.setCreateTime(new Date());
                    insertPO.setUpdateUserId(defaultUserId);
                    insertPO.setUpdateUserName(defaultUserName);
                    insertPO.setUpdateTime(new Date());
                    insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                    batchInsertPOList.add(insertPO);
                    item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                }
            }

            // 处理新增数据
            if (ObjectUtil.isNotEmpty(batchInsertPOList)) {
                bcmBudgetProjectInfoMapper.insertBatch(batchInsertPOList);
            }

            // 批量更新临时表数据
            Map<String, List<BcmTbBudgetsubFmisPO>> dealResultMap = pageList.stream().collect(Collectors.groupingBy(BcmTbBudgetsubFmisPO::getDealResult));
            Iterator<String> iterator = dealResultMap.keySet().iterator();
            while (iterator.hasNext()) {
                String dealResult = iterator.next();
                List<BcmTbBudgetsubFmisPO> dealResultPOList = dealResultMap.get(dealResult);
                List<Long> dealIds = dealResultPOList.stream().map(BcmTbBudgetsubFmisPO::getId).collect(Collectors.toList());
                BcmTbBudgetsubFmisUpdatePO fmisSetPO = new BcmTbBudgetsubFmisUpdatePO();
                fmisSetPO.setDealResult(dealResult);
                fmisSetPO.setDealTime(new Date());
                BcmTbBudgetsubFmisUpdatePO fmisWherePO = new BcmTbBudgetsubFmisUpdatePO();
                fmisWherePO.setIdList(dealIds);
                bcmTbBudgetsubFmisMapper.updateBy(fmisSetPO,fmisWherePO);
            }
            pageNo ++;
        }
    }
}
