package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmQueryOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.task.api.BcmFinanceOrgSyncTaskService;
import com.tydic.bcm.personal.utils.BcmHttpUtil;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： BcmFinanceOrgSyncTaskServiceImpl
 * 说明：财务组织同步比对任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/16 16:46
 */
@HTServiceImpl
@Slf4j
public class BcmFinanceOrgSyncTaskServiceImpl implements BcmFinanceOrgSyncTaskService {

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;

    @Value("${DEAL_FINANCE_ORG_COUNT:100}")
    private Integer dealCount;

    @Value("${SYNC_FINANCE_ORG_ALL_URL:}")
    private String syncFinanceOrgAllUrl;

    @Value("${SYNC_ORG_EXT_ALL_URL:}")
    private String syncOrgExtAllUrl;

    private static final Integer delPage = 1;

    @Override
    public void syncFinanceOrg() {
        // 每次同步之前先全量同步一次
        JSONObject reqStr = new JSONObject();
        reqStr.put("extField2", "0");
        log.info("同步之前调用能力平台清除上次的标志入参为：{}", reqStr.toJSONString());
        String rspStr = BcmHttpUtil.doPost(syncOrgExtAllUrl, reqStr.toJSONString());
        log.info("同步之前调用能力平台清除上次的标志出参为：{}", rspStr);

        // 根据字符串“GUWP_USER”查询SYNC_LOG表中的记录，获取上次执行时间LAST_DATE，如果没有就为空
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType(BcmPersonalCommonConstant.SyncLogDataType.NC_ORG);
        BcmSyncLogPO bcmSyncLogPO = bcmSyncLogMapper.getModelBy(syncLogPO);


        // 默认查第一页
        int pageNo = delPage;
        // 循环、分页查询ORG_ORGS_FMIS表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
        BcmQueryOrgOrgsFmisPO qryPO = new BcmQueryOrgOrgsFmisPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        while (true) {
            Page<BcmOrgOrgsFmisPO> page = new Page<>(pageNo, dealCount);
            List<BcmOrgOrgsFmisPO> pageList = bcmOrgOrgsFmisMapper.getPageList(qryPO, page);
            if (ObjectUtil.isEmpty(pageList)) {
                if (ObjectUtil.isNotEmpty(bcmSyncLogPO) && ObjectUtil.isNotEmpty(bcmSyncLogPO.getLastDate())) {
                    // 数据处理完了，修改处理记录
                    BcmSyncLogPO updateLogPO = new BcmSyncLogPO();
                    updateLogPO.setId(bcmSyncLogPO.getId());
                    updateLogPO.setLastDate(new Date());
                    bcmSyncLogMapper.updateById(updateLogPO);
                } else {
                    // 在sync_log里面新增一条记录
                    BcmSyncLogPO insertLogPO = new BcmSyncLogPO();
                    insertLogPO.setId(BcmIdUtil.nextId());
                    insertLogPO.setDataType(BcmPersonalCommonConstant.SyncLogDataType.NC_ORG);
                    insertLogPO.setLastDate(new Date());
                    bcmSyncLogMapper.insert(insertLogPO);
                }
                return;
            }

            // 调用能力平台
            doAbilityMethod(pageList, syncFinanceOrgAllUrl);

            pageNo++;
        }
    }

    /**
     * 调用能力平台
     * @param successPOList
     * @param url
     */
    private void doAbilityMethod(List<BcmOrgOrgsFmisPO> successPOList,String url) {
        List<Long> idList = successPOList.stream().map(BcmOrgOrgsFmisPO::getId).collect(Collectors.toList());
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("同步财务组织调用能力平台入参为：{}", reqStr);
        String rspStr =  BcmHttpUtil.doPost(url, reqStr);
        log.info("同步财务组织调用能力平台出参为：{}",rspStr);
        // 根据能力平台返回判断
        if (!rspStr.contains("失败")) {
            changeDealResult(idList,BcmPersonalCommonConstant.DealResult.SUCCESS);
        } else {
            changeDealResult(idList,BcmPersonalCommonConstant.DealResult.FAIL);
        }
    }

    /**
     * 更新状态
     * @param ids
     */
    private void changeDealResult(List<Long> ids,String dealResult) {
        BcmQueryOrgOrgsFmisPO updatePO = new BcmQueryOrgOrgsFmisPO();
        updatePO.setDealResult(dealResult);
        updatePO.setDealTime(new Date());
        updatePO.setIdList(ids);
        bcmOrgOrgsFmisMapper.updateBatchById(updatePO);
    }
}
