package com.tydic.bcm.personal.task.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFinanceMatterApplyMapper;
import com.tydic.bcm.personal.dao.BcmFmisFinmattersMapper;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyExtendPO;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyPO;
import com.tydic.bcm.personal.po.BcmFmisFinmattersPO;
import com.tydic.bcm.personal.po.BcmQueryFmisFinmattersPO;
import com.tydic.bcm.personal.task.api.BcmFmisFinmattersSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisFinmattersSyncTaskReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisFinmattersSyncTaskRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题 BcmFmisFinmattersSyncTaskServiceImpl
 * 说明 财务事项申请单同步对比实现
 * 时间 2023/8/17 11:20
 *
 * @author 唐富强
 */
@HTServiceImpl
@Slf4j
public class BcmFmisFinmattersSyncTaskServiceImpl implements BcmFmisFinmattersSyncTaskService {

    @Autowired
    private BcmFmisFinmattersMapper bcmFmisFinmattersMapper;

    @Autowired
    private BcmFinanceMatterApplyMapper bcmFinanceMatterApplyMapper;

    @Value("${dealSize:100}")
    private Integer dealSize;


    /**
     * 财务事项申请单同步对比实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmFmisFinmattersSyncTaskRspBO syncFmisFinmatters(BcmFmisFinmattersSyncTaskReqBO reqBO) {
        //数据对比同步
        sync();
        return BcmRuUtil.success(BcmFmisFinmattersSyncTaskRspBO.class);
    }

    /**
     * 数据对比同步
     */
    private void sync() {
        Page<BcmFmisFinmattersPO> page = getFmisFinmatters();
        List<BcmFmisFinmattersPO> list = page.getResult();
        //未查询到待同步数据直接结束
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        //同步成功的idList
        List<Long> successIdList = new ArrayList<>(list.size());
        Map<String, BcmFinanceMatterApplyPO> thanMap = getFinanceMatterApply(list);
        if (CollectionUtils.isEmpty(thanMap)) {
            addFinanceMatterApply(list);
            successIdList = list.stream().map(BcmFmisFinmattersPO::getId).collect(Collectors.toList());
        } else {
            //无需同步idList
            List<Long> skipIdList = new ArrayList<>(list.size());
            //需要新增的事务申请单数据
            List<BcmFmisFinmattersPO> addList = new ArrayList<>(list.size());
            //需要的事务申请单数据
            List<BcmFinanceMatterApplyPO> updateList = new ArrayList<>(list.size());

            for (BcmFmisFinmattersPO po : list) {
                BcmFinanceMatterApplyPO fmaPO = thanMap.get(po.getFileId());
                if (fmaPO == null) {
                    addList.add(po);
                    successIdList.add(po.getId());
                } else {
                    if (!po.getItemName().equals(fmaPO.getFinanceApplyName())
                            || !po.getObjCode().equals(fmaPO.getBudgetProjectCode())
                            || !po.getObjName().equals(fmaPO.getBudgetProjectName())
                            || !po.getCode().equals(fmaPO.getFinanceOrgCode())
                            || !po.getName().equals(fmaPO.getFinanceOrgName())
                    ) {
                        fmaPO = setUpdateBcmFinanceMatterApplyPO(fmaPO, po);
                        successIdList.add(po.getId());
                        updateList.add(fmaPO);
                    } else {
                        skipIdList.add(po.getId());
                    }
                }
            }
            //更新财务事项申请单
            if (!CollectionUtils.isEmpty(updateList)) {
                bcmFinanceMatterApplyMapper.updadateBath(updateList);
            }
            //新增财务事项申请单
            if (!CollectionUtils.isEmpty(addList)) {
                addFinanceMatterApply(addList);
            }
            //更新NC基础数据临时表：财务事项申请单
            if (!CollectionUtils.isEmpty(skipIdList)) {
                updateFmisFinmatters(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
            }
        }
        if (!CollectionUtils.isEmpty(successIdList)) {
            updateFmisFinmatters(successIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (page.getTotalPages() > 1) {
            sync();
        }
    }

    /**
     * 设置需要更新的财务申请单数据
     *
     * @param fmaPO
     * @param po
     * @return
     */
    private BcmFinanceMatterApplyPO setUpdateBcmFinanceMatterApplyPO(BcmFinanceMatterApplyPO fmaPO, BcmFmisFinmattersPO po) {
        fmaPO.setFinanceApplyName(po.getItemName());
        fmaPO.setBudgetProjectCode(po.getObjCode());
        fmaPO.setBudgetProjectName(po.getObjName());
        fmaPO.setFinanceOrgCode(po.getCode());
        fmaPO.setFinanceOrgName(po.getName());
        fmaPO.setUpdateUserName(po.getModifier());
        if (StringUtils.isNotBlank(po.getModifiedTime())) {
            fmaPO.setUpdateTime(strToDate(po.getModifiedTime()));
        }
        return fmaPO;
    }

    /**
     * 更新NC基础数据临时表：财务事项申请单
     */
    private void updateFmisFinmatters(List<Long> idList, String dealResult) {
        BcmQueryFmisFinmattersPO bcmQueryFmisFinmattersPO = new BcmQueryFmisFinmattersPO();
        bcmQueryFmisFinmattersPO.setIdList(idList);
        bcmQueryFmisFinmattersPO.setDealResult(dealResult);
        bcmQueryFmisFinmattersPO.setDealTime(new Date());
        bcmFmisFinmattersMapper.updateBathById(bcmQueryFmisFinmattersPO);

    }

    /**
     * 待同步财务事项申请单获取
     *
     * @return
     */
    private Page<BcmFmisFinmattersPO> getFmisFinmatters() {
        BcmQueryFmisFinmattersPO bcmQueryFmisFinmattersPO = new BcmQueryFmisFinmattersPO();
        bcmQueryFmisFinmattersPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        Page<BcmFmisFinmattersPO> page = new Page<>(1, dealSize);
        List<BcmFmisFinmattersPO> pageList = bcmFmisFinmattersMapper.getPageList(bcmQueryFmisFinmattersPO, page);
        page.setResult(pageList);
        return page;
    }

    /**
     * 新增财务事项申请单
     *
     * @param list
     */
    private void addFinanceMatterApply(List<BcmFmisFinmattersPO> list) {
        List<BcmFinanceMatterApplyPO> financeMatterApplyPOList = new ArrayList<>(list.size());
        for (BcmFmisFinmattersPO fso : list) {
            BcmFinanceMatterApplyPO fsoApplyPO = setBcmFinanceMatterApplyPO(fso);
            financeMatterApplyPOList.add(fsoApplyPO);
        }
        bcmFinanceMatterApplyMapper.insertBatch(financeMatterApplyPOList);
    }

    /**
     * 财务事项申请单PO设置
     *
     * @param po
     * @return
     */
    private BcmFinanceMatterApplyPO setBcmFinanceMatterApplyPO(BcmFmisFinmattersPO po) {
        log.info("新增PO" + JSONObject.toJSONString(po));
        BcmFinanceMatterApplyPO fsoApplyPO = new BcmFinanceMatterApplyPO();
        fsoApplyPO.setId(po.getId());
        fsoApplyPO.setFinanceApplyCode(po.getFileId());
        fsoApplyPO.setFinanceApplyName(po.getItemName());
        fsoApplyPO.setBudgetProjectCode(po.getObjCode());
        fsoApplyPO.setBudgetProjectName(po.getObjName());
        fsoApplyPO.setFinanceOrgCode(po.getCode());
        fsoApplyPO.setFinanceOrgName(po.getName());
        fsoApplyPO.setCreateUserName(po.getCreator());
        fsoApplyPO.setUpdateUserName(po.getModifier());
        fsoApplyPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        fsoApplyPO.setCreateTime(strToDate(po.getCreateTime()));
        if (StringUtils.isBlank(po.getModifiedTime())) {
            fsoApplyPO.setUpdateTime(strToDate(po.getCreateTime()));
        } else {
            fsoApplyPO.setUpdateTime(strToDate(po.getModifiedTime()));
        }
        return fsoApplyPO;
    }

    /**
     * 字符串转时间
     *
     * @param str
     * @return
     */
    private Date strToDate(String str) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
        } catch (ParseException e) {
            throw new ZTBusinessException("时间错误");
        }
    }

    /**
     * 财务事项申请单获取
     *
     * @param list
     * @return
     */
    private Map<String, BcmFinanceMatterApplyPO> getFinanceMatterApply(List<BcmFmisFinmattersPO> list) {
        BcmFinanceMatterApplyExtendPO bcmFinanceMatterApplyExtendPO = new BcmFinanceMatterApplyExtendPO();
        bcmFinanceMatterApplyExtendPO.setFinanceApplyCodeList(list.stream().map(BcmFmisFinmattersPO::getFileId).collect(Collectors.toList()));
        bcmFinanceMatterApplyExtendPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        List<BcmFinanceMatterApplyPO> financeMatterApplyList = bcmFinanceMatterApplyMapper.getList(bcmFinanceMatterApplyExtendPO);
        if (CollectionUtils.isEmpty(financeMatterApplyList)) {
            return null;
        }
        return financeMatterApplyList.stream().collect(Collectors.toMap(BcmFinanceMatterApplyPO::getFinanceApplyCode, o -> o, (k1, k2) -> k2));
    }
}
