package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.ContractStatusEnum;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpContractInfoMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoExtendPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoPO;
import com.tydic.bcm.personal.task.api.BcmIpmpContractSyncTaskService;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 用于(IPMP)合同的同步与比对
 *
 * @author : civism
 * @version 1.0
 * @date 2023/8/18 10:36
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class BcmIpmpContractSyncTaskServiceImpl implements BcmIpmpContractSyncTaskService {

    private final BcmSyncLogMapper bcmSyncLogMapper;


    private final TChnipmpContractInfoMapper tChnipmpContractInfoMapper;


    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;


    @Value("${SYNC_IPMP_CONTRACT_URL:}")
    private String syncIpmpContractUrl;

    @Override
    public void syncIpmpContract() {
        // 根据字符串“GUWP_USER”查询SYNC_LOG表中的记录，获取上次执行时间LAST_DATE，如果没有就为空
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_CONTRACT);
        BcmSyncLogPO bcmSyncLogPO = bcmSyncLogMapper.getModelBy(syncLogPO);

        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;

        while (true) {
            Page<TChnipmpContractInfoPO> page = new Page<>(pageNo, dealCount);

            //插叙需要同步的数据
            TChnipmpContractInfoExtendPO contract = new TChnipmpContractInfoExtendPO();
            contract.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
            contract.setGtPushDate(pushDate);
            List<String> contractStatusList = Lists.newArrayList(ContractStatusEnum.NEW.getContractStatus(), ContractStatusEnum.AUDIT_ING.getContractStatus(), ContractStatusEnum.TRANSFER_ING.getContractStatus(),
                    ContractStatusEnum.TRANSFERRED.getContractStatus(),
                    ContractStatusEnum.CHANGE_COMPLETION.getContractStatus(), ContractStatusEnum.FINISH.getContractStatus(), ContractStatusEnum.CANCEL.getStatusDesc()
            );
            contract.setContractStatusList(contractStatusList);
            List<TChnipmpContractInfoPO> needDealContractList = tChnipmpContractInfoMapper.queryAllByLimit(contract, page);
            if (CollectionUtil.isEmpty(needDealContractList)) {
                finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
                break;
            }
            List<String> contractIds = needDealContractList.stream().map(TChnipmpContractInfoPO::getId).collect(Collectors.toList());

            Map<String, TChnipmpContractInfoPO> existContractMap = new HashMap<>();
            if (pushDate != null) {
                List<TChnipmpContractInfoPO> existSupplier = tChnipmpContractInfoMapper.queryLastByOutId(contractIds, pushDate);
                if (CollectionUtil.isNotEmpty(existSupplier)) {
                    existContractMap.putAll(existSupplier.stream().collect(Collectors.toMap(TChnipmpContractInfoPO::getId, Function.identity())));
                }
            }
            List<TChnipmpContractInfoPO> sendList = new ArrayList<>();

            List<TChnipmpContractInfoPO> resultList = new ArrayList<>();
            for (TChnipmpContractInfoPO need : needDealContractList) {

                need.setDealTime(new Date());
                TChnipmpContractInfoPO contractInfoPO = existContractMap.get(need.getId());
                if (!need.equals(contractInfoPO)) {
                    need.setContractNo("XY" + need.getContractNo());
                    if (StrUtil.isNotBlank(need.getOriginContractNo())) {
                        need.setOriginContractNo("XY" + need.getOriginContractNo());
                    }
                    sendList.add(need);
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                } else {
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                }
                resultList.add(need);
            }

            // 调用能力平
            //需要发送给能力平台
            if (CollectionUtil.isNotEmpty(sendList)) {
                boolean success = doAbilityMethod(sendList);
                if (!success) {
                    List<Long> failIds = sendList.stream().map(TChnipmpContractInfoPO::getDataId).collect(Collectors.toList());
                    resultList.forEach(contractInfo -> {
                                if (failIds.contains(contractInfo.getDataId())) {
                                    contractInfo.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                                }
                            }
                    );
                }
            }
            //更该数据结果记录
            if (CollectionUtil.isNotEmpty(resultList)) {
                tChnipmpContractInfoMapper.insertOrUpdateBatch(resultList);
            }
            pageNo++;


        }

    }


    private boolean doAbilityMethod(List<TChnipmpContractInfoPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("同步供应商调用能力平台入参为：{}", successPOList);
        String rspStr = HttpUtil.post(syncIpmpContractUrl, reqStr);
        log.info("同步供应商调用能力平台出参为：{}", rspStr);
        // 根据能力平台返回判断
        return !rspStr.contains("失败");
    }

    //记录同步
    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_CONTRACT);
            saveSyncLog.setLastDate(new Date());
            bcmSyncLogMapper.insert(saveSyncLog);
        }
    }
}
