package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpSupplierUserMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierUserExtendPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierUserPO;
import com.tydic.bcm.personal.task.api.BcmIpmpSupplierUserSyncTaskService;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/17 14:29
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class BcmIpmpSupplierUserSyncTaskServiceImpl implements BcmIpmpSupplierUserSyncTaskService {

    private final BcmSyncLogMapper bcmSyncLogMapper;


    private final TChnipmpSupplierUserMapper chnipmpSupplierUserMapper;


    @Value("${SYNC_SUPPLIER_USER_URL:}")
    private String syncSupplierUserUrl;


    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;

    @Override
    public void syncIpmpSupplierUser() {

        // 根据字符串“GUWP_USER”查询SYNC_LOG表中的记录，获取上次执行时间LAST_DATE，如果没有就为空
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_SUPPLIER_USER);
        BcmSyncLogPO bcmSyncLogPO = bcmSyncLogMapper.getModelBy(syncLogPO);

        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;

        while (true) {
            Page<TChnipmpSupplierUserPO> page = new Page<>(pageNo, dealCount);

            //插叙需要同步的数据
            TChnipmpSupplierUserExtendPO supplierUser = new TChnipmpSupplierUserExtendPO();
            supplierUser.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
            supplierUser.setGtPushDate(pushDate);
            List<TChnipmpSupplierUserPO> needDealSupplierUserList = chnipmpSupplierUserMapper.queryAllByLimit(supplierUser, page);
            if (CollectionUtil.isEmpty(needDealSupplierUserList)) {
                finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
                break;
            }
            List<String> userIds = needDealSupplierUserList.stream().map(TChnipmpSupplierUserPO::getUserId).collect(Collectors.toList());


            Map<String, TChnipmpSupplierUserPO> existSupplierUserMap = new HashMap<>();
            if (pushDate != null) {
                List<TChnipmpSupplierUserPO> existSupplierUser = chnipmpSupplierUserMapper.queryLastByUserId(userIds, pushDate);
                if (CollectionUtil.isNotEmpty(existSupplierUser)) {
                    existSupplierUserMap.putAll(existSupplierUser.stream().collect(Collectors.toMap(TChnipmpSupplierUserPO::getUserId, Function.identity())));
                }
            }

            List<TChnipmpSupplierUserPO> sendList = new ArrayList<>();

            List<TChnipmpSupplierUserPO> resultList = new ArrayList<>();
            for (TChnipmpSupplierUserPO need : needDealSupplierUserList) {
                need.setDealTime(new Date());
                TChnipmpSupplierUserPO supplierUserPO = existSupplierUserMap.get(need.getUserId());
                if (!need.equals(supplierUserPO)) {
                    sendList.add(need);
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                } else {
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                }
                resultList.add(need);
            }
            //需要发送给能力平台
            if (CollectionUtil.isNotEmpty(sendList)) {
                boolean success = doAbilityMethod(sendList);
                if (!success) {
                    List<Long> failIds = sendList.stream().map(TChnipmpSupplierUserPO::getId).collect(Collectors.toList());
                    resultList.forEach(tChnipmpSupplierUserPO -> {
                                if (failIds.contains(tChnipmpSupplierUserPO.getId())) {
                                    tChnipmpSupplierUserPO.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                                }
                            }
                    );
                }
            }
            //更该数据结果记录
            if (CollectionUtil.isNotEmpty(resultList)) {
                chnipmpSupplierUserMapper.insertOrUpdateBatch(resultList);
            }
            pageNo++;
        }


    }


    private boolean doAbilityMethod(List<TChnipmpSupplierUserPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("同步供应商用户调用能力平台入参为：{}", successPOList);
        String rspStr = HttpUtil.post(syncSupplierUserUrl, reqStr);
        log.info("同步供应商用户调用能力平台出参为：{}", rspStr);
        // 根据能力平台返回判断
        return !rspStr.contains("失败");
    }

    //记录同步
    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_SUPPLIER_USER);
            saveSyncLog.setLastDate(new Date());
            bcmSyncLogMapper.insert(saveSyncLog);
        }
    }


}
