package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmUserOrgGuwpMapper;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.task.api.BcmPositionSyncTaskService;
import com.tydic.bcm.personal.utils.BcmHttpUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： BcmPositionSyncTaskServiceImpl
 * 说明：用户兼职同步任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/18 12:37
 */
@HTServiceImpl
@Slf4j
public class BcmPositionSyncTaskServiceImpl implements BcmPositionSyncTaskService {

    @Autowired
    private BcmUserOrgGuwpMapper bcmUserOrgGuwpMapper;

    @Value("${DEAL_POSITION_COUNT:100}")
    private Integer dealCount;

    @Value("${SYNC_CUST_PART_ALL_URL:}")
    private String syncCustPartAllUrl;

    @Value("${FINISH_PART_SYNC:}")
    private String finishPartSync;

    private static final Integer delPage = 1;

    @Override
    public void syncPosition() {
        // 默认查第一页
        int pageNo = delPage;
        // 循环、分页查询ORG_ORGS_FMIS表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
        BcmUserOrgGuwpQueryPO qryPO = new BcmUserOrgGuwpQueryPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        while (true) {
            Page<BcmUserOrgGuwpPO> page = new Page<>(pageNo, dealCount);
            List<BcmUserOrgGuwpPO> pageList = bcmUserOrgGuwpMapper.getPageList(qryPO, page);
            if (ObjectUtil.isEmpty(pageList)) {
                // 如果查不出来记录了，调用同步结束标识
                JSONObject reqStr = new JSONObject();
                reqStr.put("batchId",formatDateTime(new Date()));
                log.info("同步结束之后调用能力平台传结束标识入参为：{}", reqStr.toJSONString());
                String rspStr =  BcmHttpUtil.doPost(finishPartSync, reqStr.toJSONString());
                log.info("同步结束之后调用能力平台传结束标识出参为：{}",rspStr);
                return;
            }

            // 调用能力平台
            doAbilityMethod(pageList, syncCustPartAllUrl);

            pageNo++;
        }
    }

    /**
     * 调用能力平台
     * @param successPOList
     * @param url
     */
    private void doAbilityMethod(List<BcmUserOrgGuwpPO> successPOList,String url) {
        List<Long> idList = successPOList.stream().map(BcmUserOrgGuwpPO::getId).collect(Collectors.toList());
        JSONObject reqStr = new JSONObject();
        reqStr.put("batchId",formatDateTime(new Date()));
        reqStr.put("syncList",successPOList);
        log.info("用户兼职同步任务调用能力平台入参为：{}", reqStr);
        String rspStr =  BcmHttpUtil.doPost(url, reqStr.toJSONString());
        log.info("用户兼职同步任务调用能力平台出参为：{}",rspStr);
        // 根据能力平台返回判断
        if (!rspStr.contains("失败")) {
            changeDealResult(idList,BcmPersonalCommonConstant.DealResult.SUCCESS);
        } else {
            changeDealResult(idList,BcmPersonalCommonConstant.DealResult.FAIL);
        }
    }

    /**
     * 更新状态
     *
     * @param ids
     */
    private void changeDealResult(List<Long> ids,String dealResult) {
        BcmUserOrgGuwpUpdatePO setPO = new BcmUserOrgGuwpUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        BcmUserOrgGuwpUpdatePO wherePO = new BcmUserOrgGuwpUpdatePO();
        wherePO.setIdList(ids);
        bcmUserOrgGuwpMapper.updateBy(setPO,wherePO);
    }

    /**
     * 时间格式化
     * @param date
     * @return
     */
    private String formatDateTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }
}
