package com.tydic.bcm.personal.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.util.StringUtils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

/**
 * 标题 BcmHttpUtil
 * 说明
 * 时间 2023/8/16 16:01
 *
 * @author 唐富强
 */
@Slf4j
public class BcmHttpUtil {
    public static String doPost(String url, String body) {
        log.info("调用url{},调用参数{}", url, body);
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            if (!StringUtils.isEmpty(body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(2000)
                    .setSocketTimeout(3000).setConnectTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity(stringEntity);
            HttpResponse response = httpClient.execute(httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                    log.info("调用返回{}", result);
                }
            }
        } catch (Exception ex) {
            log.error("HTTP请求异常:{}", ex);
            return null;
        }
        return result;
    }

    public static String httpGetClient(String url) {
        String result = "";
        BufferedReader in = null;
        //设置登录信息
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 建立实际的连接
            connection.connect();
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            System.out.println("发送GET请求出现异常！" + e);
            e.printStackTrace();
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
}
