package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmAddRelaAddressGroupService;
import com.tydic.bcm.personal.address.bo.BcmRelaAddressGroupBO;
import com.tydic.bcm.personal.address.bo.BcmAddRelaAddressGroupReqBO;
import com.tydic.bcm.personal.address.bo.BcmAddRelaAddressGroupRspBO;
import com.tydic.bcm.personal.dao.BcmAddressGroupRelaAddressMapper;
import com.tydic.bcm.personal.po.BcmAddressGroupRelaAddressPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@HTServiceImpl
public class BcmAddRelaAddressGroupServiceImpl implements BcmAddRelaAddressGroupService {

    @Autowired
    private BcmAddressGroupRelaAddressMapper bcmAddressGroupRelaAddressMapper;

    @Override
    public BcmAddRelaAddressGroupRspBO addRelaAddressGroup(BcmAddRelaAddressGroupReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmAddRelaAddressGroupRspBO rspBO = new BcmAddRelaAddressGroupRspBO();


        // 新增关联关系
        if (reqBO.getOperType() == 1) {
            insertRel(reqBO);
        }
        // 按 地址分组id 修改关联关系
        else if (reqBO.getOperType() == 2) {
            updateRelByGroupId(reqBO);
        }
        // 按 地址id 修改关联关系
        else if (reqBO.getOperType() == 3) {
            updateRelByAddressId(reqBO);
        }
        // 删除关联关系
        else if (reqBO.getOperType() == 4) {
            deleteRel(reqBO);
        }


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 新增关联关系
     *
     * @param reqBO
     */
    private void insertRel(BcmAddRelaAddressGroupReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getRelInfoList())) {
            return;
        }
        List<BcmAddressGroupRelaAddressPO> insertList = JUtil.jsl(reqBO.getRelInfoList(), BcmAddressGroupRelaAddressPO.class);
        for (BcmAddressGroupRelaAddressPO each : insertList) {
            each.setId(BcmIdUtil.nextId());
            each.setCreateUserId(reqBO.getCreateUserId());
            each.setCreateUserName(reqBO.getCreateUserName());
            each.setCreateTime(reqBO.getCreateTime());
        }
        bcmAddressGroupRelaAddressMapper.insertBatch(insertList);
    }


    /**
     * 按 地址分组id 修改关联关系
     *
     * @param reqBO
     */
    private void updateRelByGroupId(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getGroupId())) {
            throw new ZTBusinessException("地址关系修改时入参【groupId】为空");
        }
        // 先按地址分组id删
        BcmAddressGroupRelaAddressPO deletePO = new BcmAddressGroupRelaAddressPO();
        deletePO.setGroupId(reqBO.getGroupId());
        bcmAddressGroupRelaAddressMapper.deleteBy(deletePO);
        // 然后新增
        if (!CollectionUtils.isEmpty(reqBO.getRelInfoList())) {
            List<Long> addressIds = reqBO.getRelInfoList().stream().map(BcmRelaAddressGroupBO::getAddressId).collect(Collectors.toList());
            List<BcmAddressGroupRelaAddressPO> insertList = new ArrayList<>();
            for (Long addressId : addressIds) {
                BcmAddressGroupRelaAddressPO insertPO = new BcmAddressGroupRelaAddressPO();
                BeanUtils.copyProperties(reqBO, insertPO);
                insertPO.setId(BcmIdUtil.nextId());
                insertPO.setGroupId(reqBO.getGroupId());
                insertPO.setAddressId(addressId);
                insertList.add(insertPO);
            }
            bcmAddressGroupRelaAddressMapper.insertBatch(insertList);
        }
    }


    /**
     * 按 地址id 修改关联关系
     *
     * @param reqBO
     */
    private void updateRelByAddressId(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getAddressId())) {
            throw new ZTBusinessException("地址关系修改时入参【addressId】为空");
        }
        // 先地址id删
        BcmAddressGroupRelaAddressPO deletePO = new BcmAddressGroupRelaAddressPO();
        deletePO.setAddressId(reqBO.getAddressId());
        bcmAddressGroupRelaAddressMapper.deleteBy(deletePO);
        // 然后新增
        if (!CollectionUtils.isEmpty(reqBO.getRelInfoList())) {
            List<Long> groupIds = reqBO.getRelInfoList().stream().map(BcmRelaAddressGroupBO::getGroupId).collect(Collectors.toList());
            List<BcmAddressGroupRelaAddressPO> insertList = new ArrayList<>();
            for (Long groupId : groupIds) {
                BcmAddressGroupRelaAddressPO insertPO = new BcmAddressGroupRelaAddressPO();
                BeanUtils.copyProperties(reqBO, insertPO);
                insertPO.setId(BcmIdUtil.nextId());
                insertPO.setGroupId(groupId);
                insertPO.setAddressId(reqBO.getAddressId());
                insertList.add(insertPO);
            }
            bcmAddressGroupRelaAddressMapper.insertBatch(insertList);
        }
    }


    /**
     * 删除关联关系
     *
     * @param reqBO
     */
    private void deleteRel(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getGroupId()) && ObjectUtil.isEmpty(reqBO.getAddressId())) {
            return;
        }
        BcmAddressGroupRelaAddressPO deletePO = new BcmAddressGroupRelaAddressPO();
        deletePO.setGroupId(reqBO.getGroupId());
        deletePO.setAddressId(reqBO.getAddressId());
        bcmAddressGroupRelaAddressMapper.deleteBy(deletePO);
    }


    /**
     * 入参校验
     *
     * @param reqBO
     * @return
     */
    private void judge(BcmAddRelaAddressGroupReqBO reqBO) {

        if (ObjectUtil.isEmpty(reqBO.getOperType())) {
            throw new ZTBusinessException("地址关系处理时入参【operType】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserId())) {
            throw new ZTBusinessException("地址关系处理时入参【createUserId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserName())) {
            throw new ZTBusinessException("地址关系处理时入参【createUserName】为空");
        }

        // 新增
        if (reqBO.getOperType() == 1) {
            if (CollectionUtils.isEmpty(reqBO.getRelInfoList())) {
                throw new ZTBusinessException("地址关系新增时入参【relInfoList】为空");
            }
            for (BcmRelaAddressGroupBO each : reqBO.getRelInfoList()) {
                if (ObjectUtil.isEmpty(each.getGroupId())) {
                    throw new ZTBusinessException("地址关系新增时入参【relInfoList.groupId】为空");
                }
                if (ObjectUtil.isEmpty(each.getAddressId())) {
                    throw new ZTBusinessException("地址关系新增时入参【relInfoList.addressId】为空");
                }
            }
        }
        // 按地址分组id修改
        else if (reqBO.getOperType() == 2) {
            if (ObjectUtil.isEmpty(reqBO.getGroupId())) {
                throw new ZTBusinessException("地址关系修改时入参【groupId】为空");
            }
        }
        // 按地址id修改
        else if (reqBO.getOperType() == 3) {
            if (ObjectUtil.isEmpty(reqBO.getAddressId())) {
                throw new ZTBusinessException("地址关系修改时入参【addressId】为空");
            }
        }
        // 删除
        else if (reqBO.getOperType() == 4) {
            if (ObjectUtil.isEmpty(reqBO.getGroupId()) && ObjectUtil.isEmpty(reqBO.getAddressId())) {
                throw new ZTBusinessException("地址关系删除时入参【groupId】和【addressId】同时为空");
            }
        } else {
            throw new ZTBusinessException("不支持的操作类型");
        }

        if (ObjectUtil.isEmpty(reqBO.getCreateTime())) {
            reqBO.setCreateTime(new Date(System.currentTimeMillis()));
        }

    }


}
