package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmSaveOrUpdateAddressGroupService;
import com.tydic.bcm.personal.address.bo.BcmSaveOrUpdateAddressGroupReqBO;
import com.tydic.bcm.personal.address.bo.BcmSaveOrUpdateAddressGroupRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmAddressGroupMapper;
import com.tydic.bcm.personal.po.BcmAddressGroupPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

@HTServiceImpl
public class BcmSaveOrUpdateAddressGroupServiceImpl implements BcmSaveOrUpdateAddressGroupService {

    @Autowired
    private BcmAddressGroupMapper bcmAddressGroupMapper;

    @Override
    public BcmSaveOrUpdateAddressGroupRspBO saveOrUpdateAddressGroup(BcmSaveOrUpdateAddressGroupReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmSaveOrUpdateAddressGroupRspBO rspBO = new BcmSaveOrUpdateAddressGroupRspBO();


        // 地址分组保存
        if (ObjectUtil.isEmpty(reqBO.getGroupId())) {
            BcmAddressGroupPO insertPO = JUtil.js(reqBO, BcmAddressGroupPO.class);
            insertPO.setId(BcmIdUtil.nextId());
            insertPO.setGroupId(BcmIdUtil.nextId());
            insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            bcmAddressGroupMapper.insert(insertPO);
        }
        // 地址分组修改
        else {
            BcmAddressGroupPO set = JUtil.js(reqBO, BcmAddressGroupPO.class);
            BcmAddressGroupPO where = new BcmAddressGroupPO();
            where.setGroupId(reqBO.getGroupId());
            bcmAddressGroupMapper.updateBy(set, where);
        }


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 入参校验
     *
     * @param reqBO
     * @return
     */
    private void judge(BcmSaveOrUpdateAddressGroupReqBO reqBO) {

        if (ObjectUtil.isEmpty(reqBO.getGroupName())) {
            throw new ZTBusinessException("地址分组保存/修改时入参【groupName】为空");
        }

        // 地址分组保存
        if (ObjectUtil.isEmpty(reqBO.getGroupId())) {

            BcmAddressGroupPO qryPO = new BcmAddressGroupPO();
            qryPO.setGroupName(reqBO.getGroupName());
            List<BcmAddressGroupPO> list = bcmAddressGroupMapper.getList(qryPO);
            if (CollectionUtils.isEmpty(list)) {
                throw new ZTBusinessException("地址分组名称“" + reqBO.getGroupName() + "”已存在");
            }

            if (ObjectUtil.isEmpty(reqBO.getCreateUserId())) {
                throw new ZTBusinessException("地址分组保存时入参【createUserId】为空");
            }
            if (ObjectUtil.isEmpty(reqBO.getCreateUserName())) {
                throw new ZTBusinessException("地址分组保存时入参【createUserName】为空");
            }
            if (ObjectUtil.isEmpty(reqBO.getCreateTime())) {
                reqBO.setCreateTime(new Date(System.currentTimeMillis()));
            }
        }
        // 地址分组修改
        else {
            if (ObjectUtil.isEmpty(reqBO.getUpdateUserId())) {
                throw new ZTBusinessException("地址分组修改时入参【updateUserId】为空");
            }
            if (ObjectUtil.isEmpty(reqBO.getUpdateUserName())) {
                throw new ZTBusinessException("地址分组修改时入参【updateUserName】为空");
            }
            if (ObjectUtil.isEmpty(reqBO.getUpdateTime())) {
                reqBO.setUpdateTime(new Date(System.currentTimeMillis()));
            }
        }

    }


}
