package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmSaveOrSubmitReplyService;
import com.tydic.bcm.personal.commodity.bo.BcmSaveOrSubmitReplyReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmSaveOrSubmitReplyRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyMapper;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * 标题 BcmSaveOrSubmitReplyServiceImpl
 * 说明 上架申请单应答-选定保存/提交实现
 * 时间 2023/8/2 14:18
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmSaveOrSubmitReplyServiceImpl implements BcmSaveOrSubmitReplyService {

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyMapper bcmApplyCommodityOrderSupplierReplyMapper;


    /**
     * 上架申请单应答-选定保存/提交实现
     * @param reqBO
     * @return
     */
    @Override

    public BcmSaveOrSubmitReplyRspBO saveOrSubmitReply(BcmSaveOrSubmitReplyReqBO reqBO) {

        //参数校验
        verifyParam(reqBO);
        BcmSaveOrSubmitReplyRspBO rspBO = BcmRuUtil.success(BcmSaveOrSubmitReplyRspBO.class);
        //修改应答明细
        updateApplyCommodityOrderSupplierReplyItem(reqBO);
        //获取已选定的应答明细
        List<BcmApplyCommodityOrderSupplierReplyItemPO> replyItemList = getReplyItemList(reqBO);
        //当操作类型为提交且存在已选定的应答明细时修改上架申请单状态
        if (BcmPersonalCommodityConstant.OperType.SUBMIT.equals(reqBO.getOperType())
                && !CollectionUtils.isEmpty(replyItemList)) {
            //是否发起流程设置
            rspBO.setIsFlow(updateApplyCommodityOrder(reqBO, replyItemList));
        } else {
            //保存不需要发起流程
            rspBO.setIsFlow(false);
        }
        //更新应答单
        if (CollectionUtils.isEmpty(replyItemList)) {
            updateSupplier(null, reqBO, BcmPersonalCommodityConstant.SelectFlag.NO);
        } else {
            Set<Long> replySet = new HashSet<>(replyItemList.size());
            for (BcmApplyCommodityOrderSupplierReplyItemPO replyItem : replyItemList) {
                replySet.add(replyItem.getReplyId());
            }
            updateSupplier(new ArrayList<>(replySet), reqBO, BcmPersonalCommodityConstant.SelectFlag.YES);
        }
        return rspBO;
    }

    /**
     * 修改应答单
     */
    private void updateSupplier(List<Long> replyIdList, BcmSaveOrSubmitReplyReqBO reqBO, Integer selectFlag) {
        BcmApplyCommodityOrderSupplierReplyPO set = new BcmApplyCommodityOrderSupplierReplyPO();
        set.setSelectFlag(selectFlag);
        set.setUpdateTime(new Date());
        set.setUpdateUserId(reqBO.getUserId());
        set.setUpdateUserName(reqBO.getName());
        BcmQueryApplyCommodityOrderSupplierReplyPO where = new BcmQueryApplyCommodityOrderSupplierReplyPO();
        where.setReplyIdList(replyIdList);
        where.setApplyOrderId(reqBO.getApplyOrderId());
        bcmApplyCommodityOrderSupplierReplyMapper.updateBatch(where, set);
    }
    /**
     * 修改上架申请单
     */
    private Boolean updateApplyCommodityOrder(BcmSaveOrSubmitReplyReqBO reqBO, List<BcmApplyCommodityOrderSupplierReplyItemPO> replyItemList) {
        BcmApplyCommodityOrderPO applyCommodityOrderPO = bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (applyCommodityOrderPO == null) {
            throw new ZTBusinessException("未查询到上架申请单");
        }
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = new BcmApplyCommodityOrderPO();
        bcmApplyCommodityOrderPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmApplyCommodityOrderPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderPO.setUpdateUserName(reqBO.getName());
        Integer applyOrderStatus = BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus();
        //已选定应答明细有还未创建商品时进入已选定状态
        for (BcmApplyCommodityOrderSupplierReplyItemPO po : replyItemList) {
            if (po.getSkuId() == null) {
                applyOrderStatus = BcmPersonalApplyOrderStatusEnum.SELECTED.getStatus();
                break;
            }
        }
        bcmApplyCommodityOrderPO.setApplyOrderStatus(applyOrderStatus);
        bcmApplyCommodityOrderMapper.update(bcmApplyCommodityOrderPO);
        //上架申请单状态为结果审批中需要发起流程
        return BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus().equals(applyOrderStatus);
    }

    /**
     * 获取已选定的应答明细
     *
     * @param reqBO
     * @return
     */
    private List<BcmApplyCommodityOrderSupplierReplyItemPO> getReplyItemList(BcmSaveOrSubmitReplyReqBO reqBO) {
        BcmQueryApplyCommodityOrderSupplierReplyItemPO bcmQueryApplyCommodityOrderSupplierReplyItemPO = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
        return bcmApplyCommodityOrderSupplierReplyItemMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyItemPO);
    }

    /**
     * 修改应答明细
     */
    private void updateApplyCommodityOrderSupplierReplyItem(BcmSaveOrSubmitReplyReqBO reqBO) {
        List<BcmQueryApplyCommodityOrderSupplierReplyItemPO> updateList = new ArrayList<>();
        //取消选定
        Date now = new Date();
        if (!CollectionUtils.isEmpty(reqBO.getCancelSelectIdList())) {
            for (Long id : reqBO.getCancelSelectIdList()) {
                BcmQueryApplyCommodityOrderSupplierReplyItemPO po = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                po.setId(id);
                po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.NO);
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserName(reqBO.getName());
                po.setUpdateTime(now);
                updateList.add(po);
            }
        }
        //选定
        if (!CollectionUtils.isEmpty(reqBO.getSelectIdList())) {
            for (Long id : reqBO.getSelectIdList()) {
                BcmQueryApplyCommodityOrderSupplierReplyItemPO po = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                po.setId(id);
                po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserName(reqBO.getName());
                po.setUpdateTime(now);
                updateList.add(po);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            bcmApplyCommodityOrderSupplierReplyItemMapper.updateBatch(updateList);
        }
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmSaveOrSubmitReplyReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getApplyOrderId() == null) {
            throw new ZTBusinessException("入参上架申请单id不能为null");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("入参操作人id不能为null");
        }
        if (StringUtils.isEmpty(reqBO.getName())) {
            throw new ZTBusinessException("入参操作人名称不能为null");
        }
        if (reqBO.getOperType() == null) {
            throw new ZTBusinessException("入参操作类型不能为null");
        }
    }

}
