package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmAddOrderFirstAuditorService;
import com.tydic.bcm.personal.common.bo.BcmAddOrderFirstAuditorReqBO;
import com.tydic.bcm.personal.common.bo.BcmAddOrderFirstAuditorRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmOrderFirstAuditorMapper;
import com.tydic.bcm.personal.po.BcmOrderFirstAuditorPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 类名： BcmAddOrderFirstAuditorServiceImpl
 * 说明：订单一级审核人新增实现
 *
 * @author： lishiqing
 * 时间： 2023/9/25 11:12
 */
@HTServiceImpl
public class BcmAddOrderFirstAuditorServiceImpl implements BcmAddOrderFirstAuditorService {

    @Autowired
    private BcmOrderFirstAuditorMapper bcmOrderFirstAuditorMapper;

    @Override
    public BcmAddOrderFirstAuditorRspBO addOrderFirstAuditor(BcmAddOrderFirstAuditorReqBO reqBO) {
        // 参数校验
        verifyParam(reqBO);

        BcmOrderFirstAuditorPO qryPO = new BcmOrderFirstAuditorPO();
        qryPO.setOrderId(reqBO.getOrderId());
        BcmOrderFirstAuditorPO firstAuditorPO = bcmOrderFirstAuditorMapper.getModelBy(qryPO);
        if (ObjectUtil.isEmpty(firstAuditorPO)) {
            // 新增
            BcmOrderFirstAuditorPO insertPO = BcmRuUtil.js(reqBO, BcmOrderFirstAuditorPO.class);
            insertPO.setId(BcmIdUtil.nextId());
            insertPO.setCreateTime(new Date());
            insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            bcmOrderFirstAuditorMapper.insert(insertPO);
        } else {
            // 修改
            BcmOrderFirstAuditorPO setPO = BcmRuUtil.js(reqBO, BcmOrderFirstAuditorPO.class);
            setPO.setUpdateTime(new Date());
            BcmOrderFirstAuditorPO wherePO = new BcmOrderFirstAuditorPO();
            wherePO.setId(firstAuditorPO.getId());
            bcmOrderFirstAuditorMapper.updateBy(setPO,wherePO);
        }
        return BcmRuUtil.success(BcmAddOrderFirstAuditorRspBO.class);
    }

    private void verifyParam(BcmAddOrderFirstAuditorReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("订单一级审核人新增实现入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getOrderId())) {
            throw new ZTBusinessException("订单一级审核人新增实现入参订单ID【orderId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAuditUserId())) {
            throw new ZTBusinessException("订单一级审核人新增实现入参审批人ID【auditUserId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAuditUserName())) {
            throw new ZTBusinessException("订单一级审核人新增实现入参审批人名称【auditUserName】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAuditOrgId())) {
            throw new ZTBusinessException("订单一级审核人新增实现入参审批人机构ID【auditOrgId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAuditOrgName())) {
            throw new ZTBusinessException("订单一级审核人新增实现入参审批人机构名称【auditOrgName】为空");
        }
    }
}
