package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.bcm.personal.common.api.BcmAddPurchasePurposeConfigService;
import com.tydic.bcm.personal.common.bo.BcmAddPurchasePurposeConfigCatalogInfoBO;
import com.tydic.bcm.personal.common.bo.BcmAddPurchasePurposeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmAddPurchasePurposeConfigRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndCommodityCategoryMapper;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndCommodityCategoryPO;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 类名： BcmAddPurchasePurposeConfigServiceImpl
 * 说明：采购用途设置-采购用途新增实现
 *
 * @author： lishiqing
 * 时间： 2023/7/21 11:13
 */
@HTServiceImpl
public class BcmAddPurchasePurposeConfigServiceImpl implements BcmAddPurchasePurposeConfigService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;

    @Autowired
    private BcmPurchasePurposeAndCommodityCategoryMapper bcmPurchasePurposeAndCommodityCategoryMapper;

    /**
     * 采购用途新增
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmAddPurchasePurposeConfigRspBO addPurchasePurposeConfig(BcmAddPurchasePurposeConfigReqBO reqBO) {
        BcmAddPurchasePurposeConfigRspBO rspBO = new BcmAddPurchasePurposeConfigRspBO();
        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmPurchasePurposeConfigPO insertPO = setReqBO(reqBO);

        // 插入数据
        int i = bcmPurchasePurposeConfigMapper.insert(insertPO);
        if (i < 1) {
            throw new ZTBusinessException("采购用途新增失败");
        }

        // 插入商品类目数据
        List<BcmPurchasePurposeAndCommodityCategoryPO> insertList = new ArrayList<>();
        for (BcmAddPurchasePurposeConfigCatalogInfoBO each : reqBO.getCatalogList()) {
            BcmPurchasePurposeAndCommodityCategoryPO insertCatalogPO = JUtil.js(insertPO, BcmPurchasePurposeAndCommodityCategoryPO.class);

            insertCatalogPO.setId(Sequence.getInstance().nextId());

            insertCatalogPO.setFirstCatalogId(each.getFirstCatalogId());
            insertCatalogPO.setFirstCatalogName(each.getFirstCatalogName());
            insertCatalogPO.setSecondaryCatalogId(each.getSecondaryCatalogId());
            insertCatalogPO.setSecondaryCatalogName(each.getSecondaryCatalogName());
            insertCatalogPO.setThirdCatalogId(each.getThirdCatalogId());
            insertCatalogPO.setThirdCatalogName(each.getThirdCatalogName());

            insertList.add(insertCatalogPO);
        }
        bcmPurchasePurposeAndCommodityCategoryMapper.insertBatch(insertList);


        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 入参组装
     *
     * @param reqBO
     * @return
     */
    private BcmPurchasePurposeConfigPO setReqBO(BcmAddPurchasePurposeConfigReqBO reqBO) {
        BcmPurchasePurposeConfigPO inertPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPurchasePurposeConfigPO.class);
        inertPO.setId(Sequence.getInstance().nextId());
        inertPO.setPurchasePurposeId(Sequence.getInstance().nextId());
        inertPO.setCreateTime(new Date());
        inertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        inertPO.setIsCommon(BcmPersonalCommonConstant.IsCommon.NO);
        return inertPO;
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmAddPurchasePurposeConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途新增入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeName())) {
            throw new ZTBusinessException("采购用途新增入参采购用途名称【purchasePurposeName】不能为空");
        }
        if (!CollectionUtils.isEmpty(reqBO.getCatalogList())) {
            for (BcmAddPurchasePurposeConfigCatalogInfoBO each : reqBO.getCatalogList()) {
                if (ObjectUtil.isEmpty(each.getFirstCatalogId())) {
                    throw new ZTBusinessException("采购用途新增入参采购一级商品类目ID【firstCatalogId】不能为空");
                }
                if (ObjectUtil.isEmpty(each.getFirstCatalogName())) {
                    throw new ZTBusinessException("采购用途新增入参采购一级商品类目名称【firstCatalogName】不能为空");
                }
            }
        } else {
            throw new ZTBusinessException("采购用途新增入参采购用途商品类目集合【catalogList】为空");
        }
    }
}
