package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.common.api.BcmAddSuggestedManagementInfoService;
import com.tydic.bcm.personal.common.bo.BcmAddSuggestedManagementInfoReqBO;
import com.tydic.bcm.personal.common.bo.BcmAddSuggestedManagementInfoRspBO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;


/**
 * 类名： BcmAddSuggestedManagementInfoServiceImpl
 * 说明：我的建议-新增我的建议实现
 *
 * @author： lishiqing
 * 时间： 2023/7/24 14:27
 */
@HTServiceImpl
public class BcmAddSuggestedManagementInfoServiceImpl implements BcmAddSuggestedManagementInfoService {

    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;

    @Autowired
    private BcmFileMapper bcmFileMapper;


    @Override
    public BcmAddSuggestedManagementInfoRspBO addSuggestedManagementInfo(BcmAddSuggestedManagementInfoReqBO reqBO) {
        BcmAddSuggestedManagementInfoRspBO rspBO = new BcmAddSuggestedManagementInfoRspBO();
        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmSuggestedManagementInfoPO insertPO = setReqBO(reqBO);

        // 插入数据
        int i = bcmSuggestedManagementInfoMapper.insert(insertPO);
        if (i < 1) {
            throw new ZTBusinessException("新增我的建议失败");
        }

        // 新增文件信息
        insertFile(reqBO, insertPO);

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 新增文件信息
     * @param reqBO
     * @param insertPO
     */
    private void insertFile(BcmAddSuggestedManagementInfoReqBO reqBO, BcmSuggestedManagementInfoPO insertPO) {
        // 判断是否传了文件信息
        if (ObjectUtil.isNotEmpty(reqBO.getFileBOList())) {
            // 参数组装
            List<BcmFilePO> insertPOList = reqBO.getFileBOList().stream().map(item -> {
                BcmFilePO bcmFilePO = JSONObject.parseObject(JSONObject.toJSONString(item), BcmFilePO.class);
                bcmFilePO.setId(BcmIdUtil.nextId());
                bcmFilePO.setFileId(BcmIdUtil.nextId().toString());
                bcmFilePO.setBusinessId(insertPO.getSuggestedId());
                bcmFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.SUGGESTION);
                bcmFilePO.setCreateTime(new Date());
                bcmFilePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                return bcmFilePO;
            }).collect(Collectors.toList());

            // 插入数据
            int m = bcmFileMapper.insertBatch(insertPOList);

            if (m < 1) {
                throw new ZTBusinessException("我的建议新增附件失败");
            }
        }
    }


    /**
     * 入参组装
     * @param reqBO
     * @return
     */
    private BcmSuggestedManagementInfoPO setReqBO(BcmAddSuggestedManagementInfoReqBO reqBO) {
        BcmSuggestedManagementInfoPO inertPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmSuggestedManagementInfoPO.class);
        inertPO.setId(BcmIdUtil.nextId());
        inertPO.setSuggestedId(BcmIdUtil.nextId());
        inertPO.setSuggestedNo("a");
        inertPO.setSuggestedTime(new Date());
        inertPO.setSuggestedNo(createSuggestedNo());
        inertPO.setDealStatus(BcmPersonalCommonConstant.SuggestedDealStatus.UNTREATED);
        inertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        return inertPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmAddSuggestedManagementInfoReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("新增我的建议入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSuggestedColumn())) {
            throw new ZTBusinessException("新增我的建议入参建议栏目【suggestedColumn】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSuggestedTitle())) {
            throw new ZTBusinessException("新增我的建议入参建议标题【suggestedTitle】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSuggestedContent())) {
            throw new ZTBusinessException("新增我的建议入参建议内容【suggestedContent】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getIsAnonymous())) {
            throw new ZTBusinessException("新增我的建议入参是否匿名【isAnonymous】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSuggestedUserId())) {
            throw new ZTBusinessException("新增我的建议入参建议人ID【suggestedUserId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSuggestedUserName())) {
            throw new ZTBusinessException("新增我的建议入参建议人名称【suggestedUserName】为空");
        }
    }

    /**
     * 生成建议单编号
     * @return
     */
    public static String createSuggestedNo() {
        // 获取当前时间
        Date now = new Date();
        // 设置日期格式为yyyyMMddHHmmss
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = sdf.format(now);

        // 生成4位随机数
        Random random = new Random();
        int randomNumber = random.nextInt(9000) + 1000;

        // 拼接编码
        String code = "JYD" + timestamp + randomNumber;

        return code;
    }
}
