package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmPurchasePurposeRelaOrCancelRelaLabelService;
import com.tydic.bcm.personal.common.bo.BcmPurchasePurposeRelaOrCancelRelaLabelReqBO;
import com.tydic.bcm.personal.common.bo.BcmPurchasePurposeRelaOrCancelRelaLabelRspBO;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

@HTServiceImpl
public class BcmPurchasePurposeRelaOrCancelRelaLabelServiceImpl implements BcmPurchasePurposeRelaOrCancelRelaLabelService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;

    @Override
    public BcmPurchasePurposeRelaOrCancelRelaLabelRspBO purchasePurposeRelaOrCancelRelaLabel(BcmPurchasePurposeRelaOrCancelRelaLabelReqBO reqBO) {
        BcmPurchasePurposeRelaOrCancelRelaLabelRspBO rspBO = new BcmPurchasePurposeRelaOrCancelRelaLabelRspBO();

        // 校验
        verifyParam(reqBO);

        // 更新 关联标签字段
        BcmPurchasePurposeConfigPO updatePO = JUtil.js(reqBO, BcmPurchasePurposeConfigPO.class);
        updatePO.setUpdateTime(new Date(System.currentTimeMillis()));
        bcmPurchasePurposeConfigMapper.updateDealRelaLabel(updatePO, reqBO.getOperType());

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmPurchasePurposeRelaOrCancelRelaLabelReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途修改入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeId())) {
            throw new ZTBusinessException("采购用途修改入参主键ID【purchasePurposeId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getOperType())) {
            throw new ZTBusinessException("采购用途修改入参操作类型【operType】不能为空");
        }
        if (reqBO.getOperType().equals("0")) {
            if (ObjectUtil.isEmpty(reqBO.getRelaLabelCode())) {
                throw new ZTBusinessException("关联时【relaLabelCode】不能为空");
            }
            if (ObjectUtil.isEmpty(reqBO.getRelaLabelName())) {
                throw new ZTBusinessException("关联时【relaLabelName】不能为空");
            }
        }
        if (ObjectUtil.isEmpty(reqBO.getUpdateUserId())) {
            throw new ZTBusinessException("采购用途修改更新人ID【updateUserId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getUpdateUserName())) {
            throw new ZTBusinessException("采购用途修改更新人名称【updateUserName】不能为空");
        }
    }

}
