package com.tydic.bcm.personal.common.impl;

import com.tydic.bcm.personal.common.api.BcmQueryAuditOrgListService;
import com.tydic.bcm.personal.common.bo.BcmAuditOrgBO;
import com.tydic.bcm.personal.common.bo.BcmQueryAuditOrgListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryAuditOrgListRspBO;
import com.tydic.bcm.personal.dao.BcmAuditOrgMapper;
import com.tydic.bcm.personal.po.BcmAuditOrgPO;
import com.tydic.bcm.personal.po.BcmQueryAuditOrgPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;
import java.util.List;

/**
 * 标题 BcmQueryAuditOrgListServiceImpl
 * 说明 审批组织列表查询
 * 时间 2023/9/25 10:34
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryAuditOrgListServiceImpl implements BcmQueryAuditOrgListService {

    @Resource
    private BcmAuditOrgMapper bcmAuditOrgMapper;

    /**
     * 审批组织列表查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryAuditOrgListRspBO queryAuditOrgList(BcmQueryAuditOrgListReqBO reqBO) {
        BcmQueryAuditOrgPO bcmQueryAuditOrgPO = BcmRuUtil.js(reqBO, BcmQueryAuditOrgPO.class);
        List<BcmAuditOrgPO> list = bcmAuditOrgMapper.getList(bcmQueryAuditOrgPO);
        BcmQueryAuditOrgListRspBO rspBO = BcmRuUtil.success(BcmQueryAuditOrgListRspBO.class);
        rspBO.setRows(BcmRuUtil.jsl(list, BcmAuditOrgBO.class));
        return rspBO;
    }
}
