package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryBranchBankPageListService;
import com.tydic.bcm.personal.common.bo.BcmBranchBankBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBranchBankPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBranchBankPageListRspBO;
import com.tydic.bcm.personal.dao.BcmBranchBankMapper;
import com.tydic.bcm.personal.po.BcmBranchBankPO;
import com.tydic.bcm.personal.po.BcmBranchBankQueryPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryBranchBankPageListServiceImpl
 * 说明 分行信息分页查询
 * 时间 2023/9/11 15:40
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryBranchBankPageListServiceImpl implements BcmQueryBranchBankPageListService {

    @Autowired
    private BcmBranchBankMapper branchBankMapper;

    /**
     * 分行信息分页查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBranchBankPageListRspBO queryBranchBankPageList(BcmQueryBranchBankPageListReqBO reqBO) {
        BcmBranchBankQueryPO bcmBranchBankQueryPO = setupBranchBankQueryPO(reqBO);
        Page<BcmBranchBankPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmBranchBankPO> list = branchBankMapper.getPageList(bcmBranchBankQueryPO, page);
        return setRspBO(list, page);
    }

    /**
     * 出参设置
     *
     * @param list
     * @param page
     * @return
     */
    private BcmQueryBranchBankPageListRspBO setRspBO(List<BcmBranchBankPO> list, Page<BcmBranchBankPO> page) {
        BcmQueryBranchBankPageListRspBO rspBO = BcmRuUtil.success(BcmQueryBranchBankPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list, BcmBranchBankBO.class));
        return rspBO;
    }

    /**
     * 查询条件设置
     *
     * @param reqBO
     * @return
     */
    private BcmBranchBankQueryPO setupBranchBankQueryPO(BcmQueryBranchBankPageListReqBO reqBO) {
        BcmBranchBankQueryPO bcmBranchBankQueryPO = BcmRuUtil.js(reqBO, BcmBranchBankQueryPO.class);
        bcmBranchBankQueryPO.setOrderBy("UPDATE_TIME DESC");
        return bcmBranchBankQueryPO;
    }
}
