package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryBudgetProjectPageListService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBudgetProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题 BcmQueryBudgetProjectPageListServiceImpl
 * 说明 预算项目查询-预算项目列表查询（分页）实现
 * 时间 2023/7/21 11:48
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryBudgetProjectPageListServiceImpl implements BcmQueryBudgetProjectPageListService {

    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    /**
     * 预算项目列表查询（分页）
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBudgetProjectPageListRspBO queryBudgetProjectPageList(BcmQueryBudgetProjectPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        BcmQueryBudgetProjectInfoPO bcmQueryBudgetProjectInfoPO = getBcmQueryBudgetProjectInfoPO(reqBO);
        Page<BcmBudgetProjectInfoPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmBudgetProjectInfoPO> list;
        if (Boolean.TRUE.equals(reqBO.getQueryAllFlag())) {
            list = bcmBudgetProjectInfoMapper.queryAllListPage(bcmQueryBudgetProjectInfoPO, page);
        } else {
            //预算项目列表查询
            list = bcmBudgetProjectInfoMapper.getListPage(bcmQueryBudgetProjectInfoPO, page);
        }
        return setRspBO(list, page);
    }


    /**
     * 出参组装
     *
     * @param list
     * @param page
     * @return
     */
    private BcmQueryBudgetProjectPageListRspBO setRspBO(List<BcmBudgetProjectInfoPO> list, Page<BcmBudgetProjectInfoPO> page) {
        BcmQueryBudgetProjectPageListRspBO rspBO = BcmRuUtil.success(BcmQueryBudgetProjectPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list, BcmBudgetProjectInfoBO.class));
        if (!CollectionUtils.isEmpty(rspBO.getRows())) {
            for (BcmBudgetProjectInfoBO bo : rspBO.getRows()) {
                if (BcmPersonalCommonConstant.Status.DISABLE.equals(bo.getStatus())) {
                    bo.setStatusStr(BcmPersonalCommonConstant.Status.DISABLE_STR);
                } else if (BcmPersonalCommonConstant.Status.ENABLE.equals(bo.getStatus())) {
                    bo.setStatusStr(BcmPersonalCommonConstant.Status.ENABLE_STR);
                }
            }
        }
        return rspBO;
    }

    /**
     * 参数组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryBudgetProjectInfoPO getBcmQueryBudgetProjectInfoPO(BcmQueryBudgetProjectPageListReqBO reqBO) {
        BcmQueryBudgetProjectInfoPO bcmQueryBudgetProjectInfoPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmQueryBudgetProjectInfoPO.class);
        bcmQueryBudgetProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryBudgetProjectInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmQueryBudgetProjectInfoPO;
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryBudgetProjectPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
