package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryFinancialOrgRelPurPurposeListService;
import com.tydic.bcm.personal.common.bo.BcmFinancialOrgRelPurPurposeBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFinancialOrgRelPurPurposeListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFinancialOrgRelPurPurposeListRspBO;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.po.BcmFinancialOrgRelPurPurposePO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名： BcmQueryFinancialOrgRelPurPurposeListServiceImpl
 * 说明：采购用途配置-查询财务机构对应的采购用途集合实现
 *
 * @author： lishiqing
 * 时间： 2023/8/11 10:45
 */
@HTServiceImpl
public class BcmQueryFinancialOrgRelPurPurposeListServiceImpl implements BcmQueryFinancialOrgRelPurPurposeListService {

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    @Override
    public BcmQueryFinancialOrgRelPurPurposeListRspBO queryFinancialOrgRelPurPurposeList(BcmQueryFinancialOrgRelPurPurposeListReqBO reqBO) {
        BcmQueryFinancialOrgRelPurPurposeListRspBO rspBO = new BcmQueryFinancialOrgRelPurPurposeListRspBO();
        //参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmFinancialOrgRelPurPurposePO qryPO = JSONObject.parseObject(JSON.toJSONString(reqBO), BcmFinancialOrgRelPurPurposePO.class);
        List<BcmFinancialOrgRelPurPurposePO> POList = bcmPurchasePurposeAndPaymentProjectRelMapper.queryFinancialOrgRelPurPurposeList(qryPO);
        if (ObjectUtil.isEmpty(POList)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }

        // 出参返回
        rspBO.setRows(JSONArray.parseArray(JSON.toJSONString(POList), BcmFinancialOrgRelPurPurposeBO.class));

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryFinancialOrgRelPurPurposeListReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("查询财务机构对应的采购用途集合入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateOrgId())) {
            throw new ZTBusinessException("查询采购用途财务组织机构id为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getQueryType())) {
            throw new ZTBusinessException("查询财务机构对应的采购用途集合入参查询类型【queryType】为空");
        }
    }
}
