package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryMyPurchasePurposePageListService;
import com.tydic.bcm.personal.common.bo.BcmPurchasePurposeInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryMyPurchasePurposePageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryMyPurchasePurposePageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQueryMyPurchasePurposePageListServiceImpl
 * 说明：采购用途设置-我的采购采购用途配置列表查询(分页)实现
 *
 * @author： lishiqing
 * 时间： 2023/7/25 10:05
 */
@HTServiceImpl
public class BcmQueryMyPurchasePurposePageListServiceImpl implements BcmQueryMyPurchasePurposePageListService {

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    @Override
    public BcmQueryMyPurchasePurposePageListRspBO queryMyPurchasePurposePageList(BcmQueryMyPurchasePurposePageListReqBO reqBO) {
        BcmQueryMyPurchasePurposePageListRspBO rspBO = new BcmQueryMyPurchasePurposePageListRspBO();

        // 入参组装
        Page<BcmPurchasePurposeAndPaymentProjectRelPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        BcmPurchasePurposeAndPaymentProjectRelPO qryPO = JSONObject.parseObject(JSON.toJSONString(reqBO), BcmPurchasePurposeAndPaymentProjectRelPO.class);

        // 根据条件关联采购用途表分页查询列表数据
        List<BcmPurchasePurposeAndPaymentProjectRelPO> poList =  bcmPurchasePurposeAndPaymentProjectRelMapper.queryMyPurchasePurposePageList(qryPO,page);

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(JSONObject.parseArray(JSONObject.toJSONString(poList), BcmPurchasePurposeInfoBO.class));

        // 如果结果为空直接返回
        if (ObjectUtil.isEmpty(rspBO.getRows())) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }

        // 翻译
        rspBO.getRows().forEach(item -> {
            if (ObjectUtil.isNotEmpty(item.getRelStatus())) {
                item.setRelStatusStr(BcmPersonalCommonConstant.RelStatus.RelStatusMap.get(item.getRelStatus()));
            }
        });

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
