package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskRspBO;
import com.tydic.bcm.personal.constants.BcmFlowTaskStatusEnum;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/2 18:10
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmUpdateFlowTaskServiceImpl implements BcmUpdateFlowTaskService {

    private final BcmFlowTaskMapper flowTaskMapper;

    private final BcmFlowInstanceMapper flowInstanceMapper;

    @Override
    public BcmUpdateFlowTaskRspBO updateFlowTask(BcmUpdateFlowTaskReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmFlowTaskPO temp = flowTaskMapper.queryByTaskId(reqBO.getTaskId());
        if (temp == null) {
            throw new ZTBusinessException("任务不存在");
        }
        //流程完结
        if (BooleanFlagEnum.YES.getFlag().equals(reqBO.getFlowFinishFlag())) {
            BcmFlowInstancePO flowInstance = new BcmFlowInstancePO();
            flowInstance.setId(reqBO.getFlowInstanceId());
            flowInstance.setFlowInstId(reqBO.getFlowInstId());
            flowInstance.setIsFinish(reqBO.getFlowFinishFlag());
            flowInstanceMapper.update(flowInstance);
        }

        //修改当前审核已完成
        BcmFlowTaskPO bcmFlowTask = BeanUtil.copyProperties(reqBO, BcmFlowTaskPO.class);
        flowTaskMapper.update(bcmFlowTask);

        //表示当前环节都结束了,其他人无需审核
        if (Boolean.TRUE.toString().equals(reqBO.getLinkJudge())) {
            BcmFlowTaskPO otherTask = BeanUtil.copyProperties(reqBO, BcmFlowTaskPO.class);
            otherTask.setCurrentNodeCode(temp.getCurrentNodeCode());
            otherTask.setFlowInstId(temp.getFlowInstId());
            otherTask.setTaskId(reqBO.getTaskId());
            otherTask.setTaskStatus(BcmFlowTaskStatusEnum.RECALL.getTaskStatus());
            flowTaskMapper.updateByNodeCode(otherTask);
        }

//        BcmFlowTaskPO bcmFlowTaskPO = new BcmFlowTaskPO();
//        bcmFlowTaskPO.setFlowInstId(temp.getFlowInstId());
//        bcmFlowTaskPO.setCurrentNodeCode(temp.getCurrentNodeCode());
//        bcmFlowTaskPO.setTaskStatusList(Lists.newArrayList(BcmFlowTaskStatusEnum.PASS.getTaskStatus(), BcmFlowTaskStatusEnum.REJECT.getTaskStatus(),
//                BcmFlowTaskStatusEnum.RECALL.getTaskStatus()));
//        List<BcmFlowTaskPO> list = flowTaskMapper.getList(bcmFlowTaskPO);
//        BcmUpdateFlowTaskRspBO bcmUpdateFlowTaskRspBO = new BcmUpdateFlowTaskRspBO();
//        bcmUpdateFlowTaskRspBO.setFlowTaskList(BcmCommonBeanUtil.listCopyProperties(list, BcmFlowTaskBO.class));
        return new BcmUpdateFlowTaskRspBO();
    }
}
