package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmAddressGroupRelaAddressPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：地址分组与地址关联表
 *
 * @author Lihulin
 * @date 2023-11-13 15:04
 **/
@Mapper
@Repository
public interface BcmAddressGroupRelaAddressMapper {

    /**
     * 插入单条数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @return int 影响数量
     */
    int insert(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo);

    /**
     * 根据条件删除数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @return int 影响数量
     */
    int deleteBy(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo);

    /**
     * 根据主键更新数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
     */
    @Deprecated
    int updateById(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmAddressGroupRelaAddressPO set, @Param("where") BcmAddressGroupRelaAddressPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo);

    /**
     * 根据条件查询单条数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @return BcmAddressGroupRelaAddressPO 结果对象
     */
    BcmAddressGroupRelaAddressPO getModelBy(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo);

    /**
     * 根据条件查询列表数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @return List<BcmAddressGroupRelaAddressPO> 结果对象
     */
    List<BcmAddressGroupRelaAddressPO> getList(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param bcmAddressGroupRelaAddressPo 参数对象
     * @param page                         分页参数
     * @return List<BcmAddressGroupRelaAddressPO> 结果对象
     */
    List<BcmAddressGroupRelaAddressPO> getListPage(BcmAddressGroupRelaAddressPO bcmAddressGroupRelaAddressPo, Page<BcmAddressGroupRelaAddressPO> page);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<BcmAddressGroupRelaAddressPO> list);

}
