package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBondDeductInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmBondDeductInfoMapper
 * 说明 保证金扣除申请信息Mapper
 * 时间 2023/7/25 10:10
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmBondDeductInfoMapper {

    /**
     * 保证金扣除申请单列表查询（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmBondDeductInfoPO> getListPage(BcmQueryBondDeductInfoPO po, Page<BcmBondDeductInfoPO> page);


    /**
     * 保证金扣除申请单列表查询
     * @param po
     * @return
     */
    List<BcmBondDeductInfoPO> getList(BcmQueryBondDeductInfoPO po);

    /**
     * 根据条件查询单条数据
     * @param po
     * @return
     */
    BcmBondDeductInfoPO getModelBy(BcmBondDeductInfoPO po);

    /**
     * 批量更新数据
     * @param list
     */
    void updateBatch(List<BcmBondDeductInfoPO> list);

    /**
     * 插入数据
     * @param po
     */
    void insert(BcmBondDeductInfoPO po);

    /**
     * 根据id批量更新
     * @param po
     */
    void updateBatchById(BcmQueryBondDeductInfoPO po);

    /**
     * 数据更新
     * @param po
     */
    void updateById(BcmBondDeductInfoPO po);
}
