package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * 标题 BcmOaApOrgMapper
 * 说明 机构信息表Mapper
 * 时间 2023/8/16 14:12
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmGuwpOrgInfoMapper {

    /**
     * 根据条件收支项目临时表分页查询列表数据
     * @param po 参数对象
     * @param page 分页参数
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmGuwpOrgInfoPO> getPageList(BcmGuwpOrgInfoQueryPO po, Page<BcmGuwpOrgInfoPO> page);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmGuwpOrgInfoUpdatePO set, @Param("where") BcmGuwpOrgInfoUpdatePO where);

    /**
     * 根据条件收支项目临时表查询列表数据
     * @param po 参数对象
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmGuwpOrgInfoPO> getList(BcmGuwpOrgInfoQueryPO po);
}