package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmOrderFirstAuditorPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 类名： bcmOrderFirstAuditorMapper
 * 说明：订单一级审核人--Mapper
 *
 * @author： lishiqing
 * 时间： 2023/9/25 10:40
 */
@Mapper
@Repository
public interface BcmOrderFirstAuditorMapper {

    /**
     * 我的建议列表（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmOrderFirstAuditorPO> getPageList(BcmOrderFirstAuditorPO po, Page<BcmOrderFirstAuditorPO> page);

    /**
     * 根据条件查询单条数据
     * @param po
     * @return
     */
    BcmOrderFirstAuditorPO getModelBy(BcmOrderFirstAuditorPO po);

    /**
     * 插入单条数据
     * @param po 参数对象
     * @return int 影响数量
     */
    int insert(BcmOrderFirstAuditorPO po);

    /**
     * 根据条件更新建议信息
     * @param set
     * @param where
     */
    void updateBy(@Param("set")BcmOrderFirstAuditorPO set, @Param("where") BcmOrderFirstAuditorPO where);

}
