package com.tydic.bcm.personal.flow.impl;

import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowInstanceService;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceReqBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceRspBO;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题 BcmQueryFlowInstanceServiceImpl
 * 说明 查询流程实例
 * 时间 2023/8/29 10:32
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryFlowInstanceServiceImpl implements BcmQueryFlowInstanceService {

    @Autowired
    private BcmFlowInstanceMapper bcmFlowInstanceMapper;

    /**
     * 查询流程实例
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryFlowInstanceRspBO queryFlowInstance(BcmQueryFlowInstanceReqBO reqBO) {

        BcmFlowInstancePO bcmFlowInstancePO = BcmRuUtil.js(reqBO, BcmFlowInstancePO.class);
        BcmFlowInstancePO model = bcmFlowInstanceMapper.getModel(bcmFlowInstancePO);
        BcmQueryFlowInstanceRspBO rspBO = BcmRuUtil.js(model, BcmQueryFlowInstanceRspBO.class);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }
}
