package com.tydic.bcm.personal.flow.impl;

import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowTskListService;
import com.tydic.bcm.personal.flow.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowTskListReqBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowTskListRspBO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryFlowTskListServiceImpl
 * 说明 查询流程任务列表实现
 * 时间 2023/9/4 14:18
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryFlowTskListServiceImpl implements BcmQueryFlowTskListService {


    @Autowired
    private BcmFlowTaskMapper bcmFlowTaskMapper;

    /**
     * 查询流程任务列表实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryFlowTskListRspBO queryFlowTskList(BcmQueryFlowTskListReqBO reqBO) {
        BcmFlowTaskPO bcmFlowTaskPO = BcmRuUtil.js(reqBO, BcmFlowTaskPO.class);
        List<BcmFlowTaskPO> list = bcmFlowTaskMapper.getList(bcmFlowTaskPO);
        BcmQueryFlowTskListRspBO rspBO = BcmRuUtil.success(BcmQueryFlowTskListRspBO.class);
        rspBO.setTaskList(BcmRuUtil.jsl(list, BcmFlowTaskBO.class));
        return rspBO;
    }
}
