package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 类名： BcmBudgetModeConfigPO
 * 说明：预算模式设置--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/7/24 9:45
 */
@Data
public class BcmBudgetModeConfigPO implements Serializable {
    private static final long serialVersionUID = -4705236992641966784L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 机构ID
     */
    private Long orgId;

    /**
     * 机构编码
     */
    private String orgCode;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 财务机构编码
     */
    private String financeOrgCode;

    /**
     * 财务机构名称
     */
    private String financeOrgName;

    /**
     * 预算模式：
     * 0：未设置
     * 1：财务事项申请单
     * 2：成本中
     */
    private Integer budgetMode;

    /**
     * 创建人ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人ID
     */
    private Long updateUserId;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 删除标识
     */
    private Integer delFlag;
}
