package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 标题 BcmFmisPaymentRecordPO
 * 说明 (NC)付款记录;NC基础数据临时表：付款记录PO
 * 时间 2023/8/18 09:57
 *
 * @author 唐富强
 */
@Data
public class BcmFmisPaymentRecordPO implements Serializable {


    private static final long serialVersionUID = -3162661748785224391L;
    /**
     * ID
     */
    private Long id;

    /**
     * 商城结算单id
     */
    private String storeId;

    /**
     * 商城结算单编号
     */
    private String storeCode;

    /**
     * 付款时间
     */
    private String paymentTime;

    /**
     * 付款金额
     */
    private String paymentAmount;

    /**
     * 付款结果;付款结果：0付款中 1成功 2驳回
     */
    private String paymentResult;

    /**
     * 付款人
     */
    private String payer;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果;处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;

    /**
     * 订单明细ID
     */
    private String orderItemId;

}