package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 类名： BcmUserInfoIpspPO
 * 说明：用户表--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/8/16 11:36
 */
@Data
public class BcmUserInfoIpspPO implements Serializable {
    private static final long serialVersionUID = -6366867022168336461L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 用户主键
     */
    private Long userId;

    /**
     * 机构ID
     */
    private Long orgId;

    /**
     * 用户编码
     */
    private String userCode;

    /**
     * 用户登录名
     */
    private String loginName;

    /**
     * 用户中文名
     */
    private String userName;

    /**
     * 用户类型
     */
    private String userType;

    /**
     * 用户性别
     */
    private String gender;

    /**
     * 手机
     */
    private String mobNo;

    /**
     * 用户邮箱
     */
    private String email;

    /**
     * 用户状态
     */
    private String userStatus;

    /**
     * 是否兼职
     */
    private String positionStatus;

    /**
     * 创建日期
     */
    private Date createTime;

    /**
     * 创建人
     */
    private Date createUser;

    /**
     * 更新者
     */
    private Long modifyUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING：待同步
     */
    private String dealResult;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BcmUserInfoIpspPO that = (BcmUserInfoIpspPO) o;
        return Objects.equals(userId, that.userId) && Objects.equals(orgId, that.orgId) && Objects.equals(userCode, that.userCode) && Objects.equals(loginName, that.loginName) && Objects.equals(userName, that.userName) && Objects.equals(userType, that.userType) && Objects.equals(gender, that.gender) && Objects.equals(mobNo, that.mobNo) && Objects.equals(email, that.email) && Objects.equals(userStatus, that.userStatus) && Objects.equals(positionStatus, that.positionStatus) && Objects.equals(createTime, that.createTime) && Objects.equals(createUser, that.createUser) && Objects.equals(modifyUser, that.modifyUser) && Objects.equals(updateTime, that.updateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, orgId, userCode, loginName, userName, userType, gender, mobNo, email, userStatus, positionStatus, createTime, createUser, modifyUser, updateTime);
    }
}
