package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名： BcmUserOrgGuwpPO
 * 说明：用户归属机构关系表--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/8/18 10:23
 */
@Data
public class BcmUserOrgGuwpPO implements Serializable {
    private static final long serialVersionUID = 8734751451916514282L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 主键ID
     */
    private Long userOrgId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 机构树ID
     */
    private Integer orgTreeId;

    /**
     * 机构ID
     */
    private Long orgId;

    /**
     * 用户顺序
     */
    private Long userOrder;

    /**
     * 创建人
     */
    private Long creator;

    /**
     * 创建日期
     */
    private Date createTime;

    /**
     * 更新者
     */
    private Long modifyUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING：待同步
     */
    private String dealResult;
}
