package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 类名： TEspSupplierBankPO
 * 说明：(IPMP)供应商银行账号--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/9/11 11:07
 */
@Data
public class TEspSupplierBankPO implements Serializable {
    private static final long serialVersionUID = -1768912070252995388L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 外部银行账号ID
     */
    private String bankId;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 开户行持卡人名字
     */
    private String userName;

    /**
     * 银行卡号
     */
    private String bankCard;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 总行ID
     */
    private String bankTypeId;

    /**
     * 支行名称
     */
    private String bankBranch;

    /**
     * 支行ID
     */
    private String bankDocId;

    /**
     * 币种
     */
    private String signCurrency;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 1：已删除 2：未删除
     */
    private String isDelete;

    /**
     * 账号状态，00-未启用，01-已启用
     */
    private String bankStatus;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果;处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TEspSupplierBankPO that = (TEspSupplierBankPO) o;
        return Objects.equals(bankId, that.bankId) && Objects.equals(supplierId, that.supplierId) && Objects.equals(userName, that.userName) && Objects.equals(bankCard, that.bankCard) && Objects.equals(bankName, that.bankName) && Objects.equals(bankTypeId, that.bankTypeId) && Objects.equals(bankBranch, that.bankBranch) && Objects.equals(bankDocId, that.bankDocId) && Objects.equals(signCurrency, that.signCurrency) && Objects.equals(province, that.province) && Objects.equals(city, that.city) && Objects.equals(isDelete, that.isDelete) && Objects.equals(bankStatus, that.bankStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bankId, supplierId, userName, bankCard, bankName, bankTypeId, bankBranch, bankDocId, signCurrency, province, city, isDelete, bankStatus);
    }
}
