package com.tydic.bcm.personal.settle.impl;

import com.tydic.bcm.personal.dao.BcmBillTellerMapper;
import com.tydic.bcm.personal.po.BcmBillTellerPO;
import com.tydic.bcm.personal.po.BcmQueryBillTellerPO;
import com.tydic.bcm.personal.settle.api.BcmQueryBillTellerListService;
import com.tydic.bcm.personal.settle.bo.BcmBillTellerBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryBillTellerListReqBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryBillTellerListRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryBillTellerListServiceImpl
 * 说明 报账员列表查询
 * 时间 2023/8/31 10:11
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryBillTellerListServiceImpl implements BcmQueryBillTellerListService {

    @Autowired
    private BcmBillTellerMapper billTellerMapper;

    /**
     * 报账员列表查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBillTellerListRspBO queryBillTellerList(BcmQueryBillTellerListReqBO reqBO) {
        BcmQueryBillTellerPO bcmQueryBillTellerPO = BcmRuUtil.js(reqBO, BcmQueryBillTellerPO.class);
        List<BcmBillTellerPO> list = billTellerMapper.getList(bcmQueryBillTellerPO);
        BcmQueryBillTellerListRspBO rspBO = BcmRuUtil.success(BcmQueryBillTellerListRspBO.class);
        rspBO.setRows(BcmRuUtil.jsl(list, BcmBillTellerBO.class));
        return rspBO;
    }
}
