package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.dao.BcmTbBudgetsubFmisMapper;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.task.api.BcmBudgetSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncBudgetProjectReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncBudgetProjectRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 类名： BcmBudgetSyncTaskServiceImpl
 * 说明：预算科目同步比对任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/15 12:49
 */
@HTServiceImpl
public class BcmBudgetSyncTaskServiceImpl implements BcmBudgetSyncTaskService {

    @Autowired
    private BcmTbBudgetsubFmisMapper bcmTbBudgetsubFmisMapper;

    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    private static final Integer delPage = 1;

    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;

    @Value("${virtual.finance.org}")
    private String virtualFinanceOrg;

    private static final Long defaultUserId = 1L;

    private static final String defaultUserName = "系统管理员";

    @Override
    @Async("global-thread-pool")
    public BcmFmisSyncBudgetProjectRspBO syncBudgetProject(BcmFmisSyncBudgetProjectReqBO reqBO) {
        BcmFmisSyncBudgetProjectRspBO rspBO = new BcmFmisSyncBudgetProjectRspBO();
        // 查询有没有待处理的数据
        BcmTbBudgetsubFmisPO qryPO = new BcmTbBudgetsubFmisPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        // 循环、分页查询TB_BUDGETSUB_FMIS表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
        int syncNum = 0;
        while (true) {
            Page<BcmTbBudgetsubFmisPO> pageNow = new Page<>(delPage, dealCount);
            List<BcmTbBudgetsubFmisPO> pageList = bcmTbBudgetsubFmisMapper.getPageList(qryPO, pageNow);
            if (ObjectUtil.isEmpty(pageList)) {
                rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
                rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
                rspBO.setSyncNum(syncNum);
                return rspBO;
            }
            // 根据TB_BUDGETSUB_FMIS的PK_OBJ去查询bcm_budget_project_info的PROJECT_ID（批量查询）
            List<String> projectIdList = pageList.stream().map(BcmTbBudgetsubFmisPO::getPkObj).collect(Collectors.toList());
            BcmQueryBudgetProjectInfoPO qryProjectPO = new BcmQueryBudgetProjectInfoPO();
            qryProjectPO.setProjectIdList(projectIdList);
            qryProjectPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            List<BcmBudgetProjectInfoPO> projectInfoPOS = bcmBudgetProjectInfoMapper.getList(qryProjectPO);
            // 新增的集合
            List<BcmBudgetProjectInfoPO> batchInsertPOList = new ArrayList<>();
            // 判断预算项目是否为空,如果不为空则存在更新数据，
            if (ObjectUtil.isNotEmpty(projectInfoPOS)) {
                // 拿到更新的集合
                Map<String, BcmBudgetProjectInfoPO> updateMap = projectInfoPOS.stream().collect(Collectors.toMap(BcmBudgetProjectInfoPO::getProjectId, Function.identity()));
                // 更新临时表的集合
                // 做更新操作
                for (BcmTbBudgetsubFmisPO item : pageList) {
                    // 查询机构信息
                    BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty(nowOrgPO) && !virtualFinanceOrg.equals(item.getPkOrg())) {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    if (!updateMap.containsKey(item.getPkObj())) { //新增
                        // 入参组装
                        BcmBudgetProjectInfoPO insertPO = setInsertReqPO(item, nowOrgPO);
                        batchInsertPOList.add(insertPO);
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.SUCCESS);
                        continue;
                    }
                    BcmBudgetProjectInfoPO sourcePO = updateMap.get(item.getPkObj());
                    BcmBudgetProjectInfoPO setPO = new BcmBudgetProjectInfoPO();
                    setPO.setProjectName(item.getObjname());
                    setPO.setProjectCode(item.getObjcode());
                    setPO.setStatus(item.getEnablestate());
                    setPO.setFinancialOrgId(item.getPkOrg());
                    //填充虚拟财务组织
                    fillVirtualFinanceOrg(setPO, nowOrgPO);
                    // 如果有值变更,
                    if (!setPO.equals(sourcePO)) {
                        setPO.setUpdateUserId(defaultUserId);
                        setPO.setUpdateUserName(defaultUserName);
                        setPO.setUpdateTime(new Date());
                        if (virtualFinanceOrg.equals(item.getPkOrg())) {
                            setPO.setPublicFlag(2);
                        } else {
                            setPO.setPublicFlag(1);
                        }
                        BcmBudgetProjectInfoPO wherePO = new BcmBudgetProjectInfoPO();
                        wherePO.setId(sourcePO.getId());
                        bcmBudgetProjectInfoMapper.updateBy(setPO, wherePO);
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.SUCCESS);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                    } else {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.SKIP);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                    }
                }
            } else {
                for (BcmTbBudgetsubFmisPO item : pageList) {
                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    // 查询机构信息
                    BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty(nowOrgPO) && !virtualFinanceOrg.equals(item.getPkOrg())) {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }
                    // 入参组装
                    BcmBudgetProjectInfoPO insertPO = setInsertReqPO(item, nowOrgPO);
                    batchInsertPOList.add(insertPO);
                    updateStatus(item, BcmPersonalCommonConstant.DealResult.SUCCESS);
                    // item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                }
            }

            // 处理新增数据
            if (ObjectUtil.isNotEmpty(batchInsertPOList)) {
                int insertNum = bcmBudgetProjectInfoMapper.insertBatch(batchInsertPOList);
                syncNum = syncNum + insertNum;
            }

            // 批量更新临时表数据
//            Map<String, List<BcmTbBudgetsubFmisPO>> dealResultMap = pageList.stream().collect(Collectors.groupingBy(BcmTbBudgetsubFmisPO::getDealResult));
//            for (String dealResult : dealResultMap.keySet()) {
//                List<BcmTbBudgetsubFmisPO> dealResultPOList = dealResultMap.get(dealResult);
//                List<Long> dealIds = dealResultPOList.stream().map(BcmTbBudgetsubFmisPO::getId).collect(Collectors.toList());
//                BcmTbBudgetsubFmisUpdatePO fmisSetPO = new BcmTbBudgetsubFmisUpdatePO();
//                fmisSetPO.setDealResult(dealResult);
//                fmisSetPO.setDealTime(new Date());
//                BcmTbBudgetsubFmisUpdatePO fmisWherePO = new BcmTbBudgetsubFmisUpdatePO();
//                fmisWherePO.setIdList(dealIds);
//                bcmTbBudgetsubFmisMapper.updateBy(fmisSetPO, fmisWherePO);
//            }
        }
    }

    /**
     * 修改临时表数据
     *
     * @param item
     * @param dealResult
     */
    private void updateStatus(BcmTbBudgetsubFmisPO item, String dealResult) {
        BcmTbBudgetsubFmisUpdatePO fmisSetPO = new BcmTbBudgetsubFmisUpdatePO();
        fmisSetPO.setDealResult(dealResult);
        fmisSetPO.setDealTime(new Date());
        BcmTbBudgetsubFmisUpdatePO fmisWherePO = new BcmTbBudgetsubFmisUpdatePO();
        fmisWherePO.setId(item.getId());
        bcmTbBudgetsubFmisMapper.updateBy(fmisSetPO, fmisWherePO);
    }

    /**
     * 设置新增PO
     *
     * @param item
     * @param nowOrgPO
     * @return
     */
    private BcmBudgetProjectInfoPO setInsertReqPO(BcmTbBudgetsubFmisPO item, BcmOrgOrgsFmisPO nowOrgPO) {
        BcmBudgetProjectInfoPO insertPO = new BcmBudgetProjectInfoPO();
        insertPO.setId(BcmIdUtil.nextId());
        insertPO.setProjectId(item.getPkObj());
        insertPO.setProjectCode(item.getObjcode());
        insertPO.setProjectName(item.getObjname());
        insertPO.setStatus(item.getEnablestate());
        //填充虚拟财务组织
        fillVirtualFinanceOrg(insertPO, nowOrgPO);
        insertPO.setCreateUserId(defaultUserId);
        insertPO.setCreateUserName(defaultUserName);
        insertPO.setCreateTime(new Date());
        insertPO.setUpdateUserId(defaultUserId);
        insertPO.setUpdateUserName(defaultUserName);
        insertPO.setUpdateTime(new Date());
        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        if (virtualFinanceOrg.equals(item.getPkOrg())) {
            insertPO.setPublicFlag(2);
        } else {
            insertPO.setPublicFlag(1);
        }
        return insertPO;
    }

    private void fillVirtualFinanceOrg(BcmBudgetProjectInfoPO bcmBudgetProjectInfoPO, BcmOrgOrgsFmisPO nowOrgPO) {
        if (nowOrgPO != null) {
            bcmBudgetProjectInfoPO.setFinancialOrgId(nowOrgPO.getPkOrg());
            bcmBudgetProjectInfoPO.setFinancialOrgCode(nowOrgPO.getCode());
            bcmBudgetProjectInfoPO.setFinancialOrgName(nowOrgPO.getName());
        } else {
            bcmBudgetProjectInfoPO.setFinancialOrgId(virtualFinanceOrg);
            bcmBudgetProjectInfoPO.setFinancialOrgCode(virtualFinanceOrg);
            bcmBudgetProjectInfoPO.setFinancialOrgName("虚拟财务组织");
        }
    }
}
