package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpContractInfoMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoExtendPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoPO;
import com.tydic.bcm.personal.task.api.BcmIpmpContractSyncTaskService;
import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;

import javax.annotation.Resource;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 用于(IPMP)合同的同步与比对
 *
 * @author : civism
 * @version 1.0
 * @date 2023/8/18 10:36
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class BcmIpmpContractSyncTaskServiceImpl implements BcmIpmpContractSyncTaskService {

    private final BcmSyncLogMapper bcmSyncLogMapper;


    private final TChnipmpContractInfoMapper tChnipmpContractInfoMapper;


    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;


    @Value("${SYNC_IPMP_CONTRACT_URL:}")
    private String syncIpmpContractUrl;

    @Resource
    private FileClient fileClient;


    @Value("${OUT_FILE_DOWN:url}")
    private String outFileDownUrl;

    @Value("${oss.fileUrl:}")
    private String ossFileUrl;
    @Value("${oss.accessUrl}")
    private String accessUrl;


    private static final String PATH = "dyc-common/";

    @Override
    @Async("contract-sync-thread-pool")
    public void syncIpmpContract() {
        // 根据字符串“GUWP_USER”查询SYNC_LOG表中的记录，获取上次执行时间LAST_DATE，如果没有就为空
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_CONTRACT);
        BcmSyncLogPO bcmSyncLogPO = bcmSyncLogMapper.getModelBy(syncLogPO);

        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;

        while (true) {
            Page<TChnipmpContractInfoPO> page = new Page<>(pageNo, dealCount);

            //插叙需要同步的数据
            TChnipmpContractInfoExtendPO contract = new TChnipmpContractInfoExtendPO();
            contract.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
            contract.setGtPushDate(pushDate);
//            List<String> contractStatusList = Lists.newArrayList(ContractStatusEnum.NEW.getContractStatus(), ContractStatusEnum.AUDIT_ING.getContractStatus(), ContractStatusEnum.TRANSFER_ING.getContractStatus(),
//                    ContractStatusEnum.TRANSFERRED.getContractStatus(), ContractStatusEnum.CHANGE_COMPLETION.getContractStatus(), ContractStatusEnum.FINISH.getContractStatus(), ContractStatusEnum.CANCEL.getContractStatus());
//            contract.setContractStatusList(contractStatusList);
            List<TChnipmpContractInfoPO> needDealContractList = tChnipmpContractInfoMapper.queryAllByLimit(contract, page);
            if (CollectionUtil.isEmpty(needDealContractList)) {
                finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
                break;
            }
            List<String> contractIds = needDealContractList.stream().map(TChnipmpContractInfoPO::getId).collect(Collectors.toList());

            Map<String, TChnipmpContractInfoPO> existContractMap = new HashMap<>();
            if (pushDate != null) {
                List<TChnipmpContractInfoPO> existSupplier = tChnipmpContractInfoMapper.queryLastByOutId(contractIds, pushDate);
                if (CollectionUtil.isNotEmpty(existSupplier)) {
                    existContractMap.putAll(existSupplier.stream().collect(Collectors.toMap(TChnipmpContractInfoPO::getId, Function.identity())));
                }
            }
            List<TChnipmpContractInfoPO> resultList = new ArrayList<>();
            for (TChnipmpContractInfoPO need : needDealContractList) {

                need.setDealTime(new Date());
                TChnipmpContractInfoPO contractInfoPO = existContractMap.get(need.getId());
                if (!need.equals(contractInfoPO)) {
                    TChnipmpContractInfoExtendPO tChnipmpContractInfoExtendPO = BeanUtil.copyProperties(need, TChnipmpContractInfoExtendPO.class);
//                    if (tChnipmpContractInfoExtendPO.getContractSum() != null && tChnipmpContractInfoExtendPO.getContractSumExcludingTax() != null) {
//                        if (BigDecimal.ZERO.compareTo(tChnipmpContractInfoExtendPO.getContractSum()) == 0 || BigDecimal.ZERO.compareTo(tChnipmpContractInfoExtendPO.getContractSumExcludingTax()) == 0) {
//                            tChnipmpContractInfoExtendPO.setTaxRate("0");
//                        } else {
//                            BigDecimal taxRate = tChnipmpContractInfoExtendPO.getContractSum().subtract(tChnipmpContractInfoExtendPO.getContractSumExcludingTax()).divide(tChnipmpContractInfoExtendPO.getContractSum(), 2, RoundingMode.HALF_UP);
//                            tChnipmpContractInfoExtendPO.setTaxRate(taxRate.toString());
//                        }
//                    }
                    //调用能力平台
                    try {
                        List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> fileList = new ArrayList<>();
                        if (StrUtil.isNotBlank(tChnipmpContractInfoExtendPO.getFileEcm0301())) {
                            List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> argFileInfoBOS = contractFile(tChnipmpContractInfoExtendPO.getFileEcm0301(), tChnipmpContractInfoExtendPO.getFileName0301());
                            fileList.addAll(argFileInfoBOS);
                        }
                        if (StrUtil.isNotBlank(tChnipmpContractInfoExtendPO.getFileEcm0305())) {
                            List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> argFileInfoBOS = contractFile(tChnipmpContractInfoExtendPO.getFileEcm0305(), tChnipmpContractInfoExtendPO.getFileName0305());
                            fileList.addAll(argFileInfoBOS);
                        }
                        if (StrUtil.isNotBlank(tChnipmpContractInfoExtendPO.getFileEcm0306())) {
                            List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> argFileInfoBOS = contractFile(tChnipmpContractInfoExtendPO.getFileEcm0306(), tChnipmpContractInfoExtendPO.getFileName0306());
                            fileList.addAll(argFileInfoBOS);
                        }

                        if (StrUtil.isNotBlank(tChnipmpContractInfoExtendPO.getFileEcm0304())) {
                            List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> argFileInfoBOS = contractFile(tChnipmpContractInfoExtendPO.getFileEcm0304(), tChnipmpContractInfoExtendPO.getFileName0304());
                            fileList.addAll(argFileInfoBOS);
                        }
                        if (StrUtil.isNotBlank(tChnipmpContractInfoExtendPO.getFileEcm0314())) {
                            List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> argFileInfoBOS = contractFile(tChnipmpContractInfoExtendPO.getFileEcm0314(), tChnipmpContractInfoExtendPO.getFileName0314());
                            fileList.addAll(argFileInfoBOS);
                        }
                        tChnipmpContractInfoExtendPO.setAgrAccessoryBOs(fileList);
                        boolean b = doAbilityMethod(tChnipmpContractInfoExtendPO);
                        if (b) {
                            need.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                        } else {
                            need.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        }
                    } catch (Exception e) {
                        log.error("合同同步失败 {}", JSON.toJSONString(tChnipmpContractInfoExtendPO), e);
                        need.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                    }
                } else {
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                }
                resultList.add(need);
            }
            //更该数据结果记录
            if (CollectionUtil.isNotEmpty(resultList)) {
                tChnipmpContractInfoMapper.insertOrUpdateBatch(resultList);
            }
        }

    }


    private List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> contractFile(String fileIdStr, String fileNameStr) {
        String[] fileIds = fileIdStr.split(",");
        String[] fileNameList = fileNameStr.split(",");
        if (ArrayUtil.isEmpty(fileIds) || ArrayUtil.isEmpty(fileNameList)) {
            throw new ZTBusinessException("文件集合不能为空");
        }
        if (fileIds.length != fileNameList.length) {
            throw new ZTBusinessException("文件集合id与名称不匹配");
        }
        List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> result = new ArrayList<>();
        for (int i = 0; i < fileIds.length; i++) {
            Map<String, Object> params = new HashMap<>(1);
            params.put("ecmId", fileIds[i]);
            InputStream inputStream = HttpRequest.post(outFileDownUrl).body(JSON.toJSONString(params)).executeAsync().bodyStream();
            String fileUrl = upload(inputStream, fileNameList[i]);
            TChnipmpContractInfoExtendPO.ArgFileInfoBO fileInfoBO = new TChnipmpContractInfoExtendPO.ArgFileInfoBO();
            fileInfoBO.setAccessoryName(fileNameList[i]);
            fileInfoBO.setAccessoryUrl(fileUrl);
            //协议主体
            fileInfoBO.setAttachmentType(1);
            result.add(fileInfoBO);
        }
        return result;

    }


    private boolean doAbilityMethod(TChnipmpContractInfoExtendPO contractInfoExtend) {
        List<BaseRspBo> baseRspBos = doAbilityMethod(Lists.newArrayList(contractInfoExtend));
        if (CollectionUtil.isNotEmpty(baseRspBos)) {
            return "0".equals(baseRspBos.get(0).getCode());
        }
        return false;
    }

    private List<BaseRspBo> doAbilityMethod(List<TChnipmpContractInfoExtendPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("同步合同调用能力平台入参为：{}", reqStr);
        String rspStr = HttpUtil.post(syncIpmpContractUrl, reqStr);
        log.info("同步合同调用能力平台出参为：{}", rspStr);
        // 根据能力平台返回判断

        return JSON.parseArray(rspStr, BaseRspBo.class);
    }

    /**
     * 记录同步
     *
     * @param syncLogId
     */
    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_CONTRACT);
            saveSyncLog.setLastDate(new Date());
            bcmSyncLogMapper.insert(saveSyncLog);
        }
    }


    private String upload(InputStream inputStream, String fileName) {
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        String path = fileClient.uploadFileByInputStream(PATH + fileDir, fileName, inputStream);
        return this.ossFileUrl + path;
    }
}
