package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpSupplierMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierExtendPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierPO;
import com.tydic.bcm.personal.task.api.BcmIpmpSupplierOrgSyncTaskService;
import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;

import javax.annotation.Resource;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/17 14:30
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class BcmIpmpSupplierOrgSyncTaskServiceImpl implements BcmIpmpSupplierOrgSyncTaskService {

    private final BcmSyncLogMapper bcmSyncLogMapper;


    private final TChnipmpSupplierMapper chnipmpSupplierMapper;


    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;


    @Value("${SYNC_SUPPLIER_ORG_URL:}")
    private String syncSupplierOrgUrl;

    @Value("${OUT_FILE_DOWN:url}")
    private String outFileDownUrl;

    @Value("${oss.fileUrl:}")
    private String ossFileUrl;
    @Resource
    private FileClient fileClient;

    private static final String PATH = "dyc-common/";

    @Override
    @Async("global-thread-pool")
    public void syncIpmpSupplierOrg() {

        // 根据字符串“GUWP_USER”查询SYNC_LOG表中的记录，获取上次执行时间LAST_DATE，如果没有就为空
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_SUPPLIER);
        BcmSyncLogPO bcmSyncLogPO = bcmSyncLogMapper.getModelBy(syncLogPO);

        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;

        while (true) {
            Page<TChnipmpSupplierPO> page = new Page<>(pageNo, dealCount);

            //插叙需要同步的数据
            TChnipmpSupplierExtendPO supplier = new TChnipmpSupplierExtendPO();
            supplier.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
            supplier.setGtPushDate(pushDate);
            List<TChnipmpSupplierPO> needDealSupplierList = chnipmpSupplierMapper.queryAllByLimit(supplier, page);
            if (CollectionUtil.isEmpty(needDealSupplierList)) {
                finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
                break;
            }
            List<String> userIds = needDealSupplierList.stream().map(TChnipmpSupplierPO::getCompanyId).collect(Collectors.toList());

            Map<String, TChnipmpSupplierPO> existSupplierMap = new HashMap<>();
            if (pushDate != null) {
                List<TChnipmpSupplierPO> existSupplier = chnipmpSupplierMapper.queryLastByCompanyId(userIds, pushDate);
                if (CollectionUtil.isNotEmpty(existSupplier)) {
                    existSupplierMap.putAll(existSupplier.stream().collect(Collectors.toMap(TChnipmpSupplierPO::getCompanyId, Function.identity())));
                }
            }
            List<TChnipmpSupplierPO> sendList = new ArrayList<>();

            List<TChnipmpSupplierPO> resultList = new ArrayList<>();
            for (TChnipmpSupplierPO need : needDealSupplierList) {

                need.setDealTime(new Date());
                TChnipmpSupplierPO supplierUserPO = existSupplierMap.get(need.getCompanyId());
                if (!need.equals(supplierUserPO)) {
                    //如果不是错误数据，需要下载oss营业执照附件
                    if (!isErrorData(need.getQlfEcmId(), need.getQlfEcmName())) {
                        // 通过ecmId查询路径并生成oss路径
                        Map<String, Object> params = new HashMap<>(1);
                        params.put("ecmId", need.getQlfEcmId());
                        InputStream inputStream = HttpRequest.post(outFileDownUrl).body(JSON.toJSONString(params)).executeAsync().bodyStream();
                        String fileUrl = upload(inputStream, need.getQlfEcmName());
                        need.setQlfEcmId(fileUrl);
                    } else {
                        log.error("需要同步的供应商数据营业执照错误 {}", JSON.toJSONString(need));
                        need.setQlfEcmId(null);
                    }
                    sendList.add(need);
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                } else {
                    need.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                }
                resultList.add(need);
            }

            // 调用能力平
            //需要发送给能力平台
            if (CollectionUtil.isNotEmpty(sendList)) {
                boolean success = doAbilityMethod(sendList);
                if (!success) {
                    List<Long> failIds = sendList.stream().map(TChnipmpSupplierPO::getId).collect(Collectors.toList());
                    resultList.forEach(tChnipmpSupplierPO -> {
                                if (failIds.contains(tChnipmpSupplierPO.getId())) {
                                    tChnipmpSupplierPO.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                                }
                            }
                    );
                }
            }
            //更该数据结果记录
            if (CollectionUtil.isNotEmpty(resultList)) {
                chnipmpSupplierMapper.insertOrUpdateBatch(resultList);
            }
        }
    }

    /**
     * 是否错误数据
     *
     * @param qlfEcmId
     * @param qlfEcmName
     * @return
     */
    private static boolean isErrorData(String qlfEcmId, String qlfEcmName) {
        if (StrUtil.isBlank(qlfEcmId) || StrUtil.isBlank(qlfEcmName)) {
            return true;
        }
        if (!StrUtil.contains(qlfEcmName, ".")) {
            return true;
        }
        return false;
    }


    private boolean doAbilityMethod(List<TChnipmpSupplierPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("同步供应商调用能力平台入参为：{}", reqStr);
        String rspStr = HttpUtil.post(syncSupplierOrgUrl, reqStr);
        log.info("同步供应商调用能力平台出参为：{}", rspStr);
        // 根据能力平台返回判断
        BaseRspBo baseRspBo = JSON.parseObject(rspStr, BaseRspBo.class);
        return "0".equals(baseRspBo.getCode());
    }

    //记录同步
    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType(BcmPersonalCommonConstant.SyncLogDataType.IPMP_SUPPLIER);
            saveSyncLog.setLastDate(new Date());
            bcmSyncLogMapper.insert(saveSyncLog);
        }
    }


    private String upload(InputStream inputStream, String fileName) {
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        String path = fileClient.uploadFileByInputStream(PATH + fileDir, fileName, inputStream);
        return this.ossFileUrl + path;
    }
}
