package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmAddReplaceAddressSkuService;
import com.tydic.bcm.personal.address.bo.BcmAddReplaceAddressSkuReqBO;
import com.tydic.bcm.personal.address.bo.BcmAddReplaceAddressSkuRspBO;
import com.tydic.bcm.personal.address.bo.BcmReplaceAddressSkuBO;
import com.tydic.bcm.personal.dao.BcmReplaceAddressSkuMapper;
import com.tydic.bcm.personal.po.BcmReplaceAddressSkuPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@HTServiceImpl
public class BcmAddReplaceAddressSkuServiceImpl implements BcmAddReplaceAddressSkuService {

    @Autowired
    public BcmReplaceAddressSkuMapper bcmReplaceAddressSkuMapper;

    @Override
    public BcmAddReplaceAddressSkuRspBO addReplaceAddressSku(BcmAddReplaceAddressSkuReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmAddReplaceAddressSkuRspBO rspBO = new BcmAddReplaceAddressSkuRspBO();


        // 根据replaceSkuId删除该用户在bcm_replace_address_sku下所有的数据
        BcmReplaceAddressSkuPO deletPO = new BcmReplaceAddressSkuPO();
        deletPO.setReplaceSkuId(reqBO.getReplaceSkuId());
        bcmReplaceAddressSkuMapper.deleteBy(deletPO);


        // 批量创建bcm_replace_address_sku记录
        if (!CollectionUtils.isEmpty(reqBO.getReplaceAddressSkuList())) {
            Date time = new Date(System.currentTimeMillis());
            List<BcmReplaceAddressSkuPO> insertList = new ArrayList<>();
            for (BcmReplaceAddressSkuBO each : reqBO.getReplaceAddressSkuList()) {
                BcmReplaceAddressSkuPO insertPO = JUtil.js(each, BcmReplaceAddressSkuPO.class);
                insertPO.setId(BcmIdUtil.nextId());
                insertPO.setCreateUserId(reqBO.getCreateUserId());
                insertPO.setCreateUserName(reqBO.getCreateUserName());
                insertPO.setCreateTime(time);
                insertPO.setIsDefault(each.getDefaultFlag());
                insertList.add(insertPO);
            }
            bcmReplaceAddressSkuMapper.insertBatch(insertList);
        }


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;

    }


    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void judge(BcmAddReplaceAddressSkuReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("代下单商品录入地址信息入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserId())) {
            throw new ZTBusinessException("代下单商品录入地址信息【createUserId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserName())) {
            throw new ZTBusinessException("代下单商品录入地址信息【createUserName】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getReplaceSkuId())) {
            throw new ZTBusinessException("代下单商品录入地址信息【replaceSkuId】为空");
        }
        if (!ObjectUtil.isEmpty(reqBO.getReplaceAddressSkuList())) {
            for (BcmReplaceAddressSkuBO each : reqBO.getReplaceAddressSkuList()) {
                if (ObjectUtil.isEmpty(each.getReplaceSkuId())) {
                    each.setReplaceSkuId(reqBO.getReplaceSkuId());
                }
                if (ObjectUtil.isEmpty(each.getBuyNum())) {
                    throw new ZTBusinessException("代下单商品录入地址信息【replaceAddressSkuList.buyNum】为空");
                }
                if (ObjectUtil.isEmpty(each.getAddressId())) {
                    throw new ZTBusinessException("代下单商品录入地址信息【replaceAddressSkuList.addressId】为空");
                }
                if (ObjectUtil.isEmpty(each.getCheckCompanyId())) {
                    throw new ZTBusinessException("代下单商品录入地址信息【replaceAddressSkuList.checkCompanyId】为空");
                }
                if (ObjectUtil.isEmpty(each.getCheckCompanyName())) {
                    throw new ZTBusinessException("代下单商品录入地址信息【replaceAddressSkuList.checkCompanyName】为空");
                }
                if (ObjectUtil.isEmpty(each.getDefaultFlag())) {
                    throw new ZTBusinessException("代下单商品录入地址信息【replaceAddressSkuList.defaultFlag】为空");
                }
            }
        }
    }


}
