package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmAddReplaceSkuService;
import com.tydic.bcm.personal.address.bo.BcmAddReplaceSkuReqBO;
import com.tydic.bcm.personal.address.bo.BcmAddReplaceSkuRspBO;
import com.tydic.bcm.personal.address.bo.BcmReplaceSkuBO;
import com.tydic.bcm.personal.dao.BcmReplaceAddressSkuMapper;
import com.tydic.bcm.personal.dao.BcmReplaceSkuMapper;
import com.tydic.bcm.personal.po.BcmReplaceSkuPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@HTServiceImpl
public class BcmAddReplaceSkuServiceImpl implements BcmAddReplaceSkuService {

    @Autowired
    public BcmReplaceAddressSkuMapper bcmReplaceAddressSkuMapper;

    @Autowired
    public BcmReplaceSkuMapper bcmReplaceSkuMapper;

    @Override
    public BcmAddReplaceSkuRspBO addReplaceSku(BcmAddReplaceSkuReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmAddReplaceSkuRspBO rspBO = new BcmAddReplaceSkuRspBO();


        // 根据用户id删除该用户在bcm_replace_sku下所有的数据
        BcmReplaceSkuPO deletePO = new BcmReplaceSkuPO();
        deletePO.setCreateUserId(reqBO.getCreateUserId());
        bcmReplaceSkuMapper.deleteBy(deletePO);


        // 然后入库多地址下单记录
        Date time = new Date(System.currentTimeMillis());
        List<BcmReplaceSkuPO> insertList = new ArrayList<>();
        for (BcmReplaceSkuBO each : reqBO.getReplaceSkuList()) {
            BcmReplaceSkuPO insertPO = JUtil.js(each, BcmReplaceSkuPO.class);
            insertPO.setId(BcmIdUtil.nextId());
            insertPO.setCreateUserId(reqBO.getCreateUserId());
            insertPO.setCreateUserName(reqBO.getCreateUserName());
            insertPO.setCreateTime(time);
            insertList.add(insertPO);
        }
        bcmReplaceSkuMapper.insertBatch(insertList);


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;

    }


    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void judge(BcmAddReplaceSkuReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("代下单商品信息保存入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserId())) {
            throw new ZTBusinessException("代下单商品信息保存【createUserId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserName())) {
            throw new ZTBusinessException("代下单商品信息保存【createUserName】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getReplaceSkuList())) {
            throw new ZTBusinessException("代下单商品信息保存【replaceSkuList】为空");
        }
        for (BcmReplaceSkuBO each : reqBO.getReplaceSkuList()) {
            if (ObjectUtil.isEmpty(each.getSkuId())) {
                throw new ZTBusinessException("代下单商品信息保存【replaceSkuList.skuId】为空");
            }
            if (ObjectUtil.isEmpty(each.getShopId())) {
                throw new ZTBusinessException("代下单商品信息保存【replaceSkuList.shopId】为空");
            }
            if (ObjectUtil.isEmpty(each.getSupplierId())) {
                throw new ZTBusinessException("代下单商品信息保存【replaceSkuList.supplierId】为空");
            }
            if (ObjectUtil.isEmpty(each.getSkuCode())) {
                throw new ZTBusinessException("代下单商品信息保存【replaceSkuList.skuCode】为空");
            }
            if (ObjectUtil.isEmpty(each.getPurchaseId())) {
                throw new ZTBusinessException("代下单商品信息保存【replaceSkuList.purchaseId】为空");
            }
            if (ObjectUtil.isEmpty(each.getPurchaseName())) {
                throw new ZTBusinessException("代下单商品信息保存【replaceSkuList.purchaseName】为空");
            }
        }
    }


}
