package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmDeleteReplaceSkuService;
import com.tydic.bcm.personal.address.bo.BcmDeleteReplaceSkuReqBO;
import com.tydic.bcm.personal.address.bo.BcmDeleteReplaceSkuRspBO;
import com.tydic.bcm.personal.dao.BcmReplaceAddressSkuMapper;
import com.tydic.bcm.personal.dao.BcmReplaceSkuMapper;
import com.tydic.bcm.personal.po.BcmReplaceAddressSkuPO;
import com.tydic.bcm.personal.po.BcmReplaceSkuPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class BcmDeleteReplaceSkuServiceImpl implements BcmDeleteReplaceSkuService {

    @Autowired
    private BcmReplaceAddressSkuMapper bcmReplaceAddressSkuMapper;
    @Autowired
    private BcmReplaceSkuMapper bcmReplaceSkuMapper;

    @Override
    public BcmDeleteReplaceSkuRspBO deleteReplaceSku(BcmDeleteReplaceSkuReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmDeleteReplaceSkuRspBO rspBO = new BcmDeleteReplaceSkuRspBO();


        // 物理删除单品关联的地址
        BcmReplaceAddressSkuPO deletePO = new BcmReplaceAddressSkuPO();
        deletePO.setReplaceSkuId(reqBO.getReplaceSkuId());
        deletePO.setAddressId(reqBO.getAddressId());
        bcmReplaceAddressSkuMapper.deleteBy(deletePO);


        // 物理删除单品
        BcmReplaceSkuPO bcmReplaceSkuPO = new BcmReplaceSkuPO();
        bcmReplaceSkuPO.setId(reqBO.getReplaceSkuId());
        bcmReplaceSkuMapper.deleteBy(bcmReplaceSkuPO);


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;

    }


    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void judge(BcmDeleteReplaceSkuReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("删除代下单商品信息入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getReplaceSkuId())) {
            throw new ZTBusinessException("删除代下单商品信息【replaceSkuId】为空");
        }
    }
}
