package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.address.api.BcmQueryPageReplaceAddressSkuService;
import com.tydic.bcm.personal.address.bo.BcmQueryPageReplaceAddressSkuReqBO;
import com.tydic.bcm.personal.address.bo.BcmQueryPageReplaceAddressSkuRspBO;
import com.tydic.bcm.personal.address.bo.BcmReplaceAddressSkuBO;
import com.tydic.bcm.personal.address.bo.BcmReplaceSkuBO;
import com.tydic.bcm.personal.dao.BcmReplaceAddressSkuMapper;
import com.tydic.bcm.personal.dao.BcmReplaceSkuMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderListPagePO;
import com.tydic.bcm.personal.po.BcmReplaceSkuAndAddressPO;
import com.tydic.bcm.personal.po.BcmReplaceSkuPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@HTServiceImpl
public class BcmQueryPageReplaceAddressSkuServiceImpl implements BcmQueryPageReplaceAddressSkuService {

    @Autowired
    private BcmReplaceSkuMapper bcmReplaceSkuMapper;
    @Autowired
    private BcmReplaceAddressSkuMapper bcmReplaceAddressSkuMapper;

    @Override
    public BcmQueryPageReplaceAddressSkuRspBO queryPageReplaceAddressSku(BcmQueryPageReplaceAddressSkuReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmQueryPageReplaceAddressSkuRspBO rspBO = new BcmQueryPageReplaceAddressSkuRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        List<BcmReplaceAddressSkuBO> rows = new ArrayList<>();


        // 查出该用户所有的单品并且内连单品对应的地址
        BcmReplaceSkuPO qryPO = new BcmReplaceSkuPO();
        qryPO.setCreateUserId(reqBO.getCreateUserId());
        Page<BcmReplaceSkuPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmReplaceSkuAndAddressPO> listPage = bcmReplaceSkuMapper.getListInnerJoinAddressByPage(qryPO,page);
        if (CollectionUtils.isEmpty(listPage)){
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            return rspBO;
        }
        List<Long> addressIds = listPage.stream().map(BcmReplaceSkuAndAddressPO::getAddressId).collect(Collectors.toList());
        qryPO.setAddressIds(addressIds);
        List<BcmReplaceSkuAndAddressPO> list = bcmReplaceSkuMapper.getListInnerJoinAddress(qryPO);

        if (!CollectionUtils.isEmpty(list)) {
            // 根据地址分组
            Map<Long, List<BcmReplaceSkuAndAddressPO>> addressIdMap = list.stream().collect(Collectors.groupingBy(BcmReplaceSkuAndAddressPO::getAddressId));
            for (BcmReplaceSkuAndAddressPO bo : listPage) {
                List<BcmReplaceSkuAndAddressPO> skuList = addressIdMap.get(bo.getAddressId());
                if (!CollectionUtils.isEmpty(skuList)) {
                    BcmReplaceAddressSkuBO addressSkuBO = JUtil.js(bo, BcmReplaceAddressSkuBO.class);
                    List<BcmReplaceSkuBO> replaceSku = JUtil.jsl(skuList, BcmReplaceSkuBO.class);
                    addressSkuBO.setReplaceSku(replaceSku);
                    //转义一 下是否默认地址
                    addressSkuBO.setDefaultFlag(bo.getIsDefault());
                    rows.add(addressSkuBO);
                }
            }
        }


        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;


    }


    /**
     * 入参校验
     *
     * @param reqBO
     * @return
     */
    private void judge(BcmQueryPageReplaceAddressSkuReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("按照地址分页查询代下单商品信息入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateUserId())) {
            throw new ZTBusinessException("按照地址分页查询代下单商品信息【CreateUserId】为空");
        }
    }
}
