package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmQueryRelaAddressGroupService;
import com.tydic.bcm.personal.address.bo.BcmQueryRelaAddressGroupReqBO;
import com.tydic.bcm.personal.address.bo.BcmQueryRelaAddressGroupRspBO;
import com.tydic.bcm.personal.address.bo.BcmRelaAddressGroupBO;
import com.tydic.bcm.personal.dao.BcmAddressGroupRelaAddressMapper;
import com.tydic.bcm.personal.po.BcmAddressGroupRelaAddressPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

@HTServiceImpl
public class BcmQueryRelaAddressGroupServiceImpl implements BcmQueryRelaAddressGroupService {

    @Autowired
    private BcmAddressGroupRelaAddressMapper bcmAddressGroupRelaAddressMapper;

    @Override
    public BcmQueryRelaAddressGroupRspBO queryRelaAddressGroup(BcmQueryRelaAddressGroupReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmQueryRelaAddressGroupRspBO rspBO = new BcmQueryRelaAddressGroupRspBO();

        BcmAddressGroupRelaAddressPO qryPO = JUtil.js(reqBO, BcmAddressGroupRelaAddressPO.class);
        List<BcmAddressGroupRelaAddressPO> list = bcmAddressGroupRelaAddressMapper.getList(qryPO);
        if (!CollectionUtils.isEmpty(list)) {
            List<BcmRelaAddressGroupBO> data = JUtil.jsl(list, BcmRelaAddressGroupBO.class);
            rspBO.setData(data);
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 入参校验
     *
     * @param reqBO
     * @return
     */
    private void judge(BcmQueryRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("地址关系查询时入参为空");
        }
    }

}
