package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.*;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.constants.*;
import com.tydic.bcm.personal.dao.*;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 上架申请单-查看详情
 *
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 14:55
 */
@HTServiceImpl
@Slf4j
public class BcmQueryApplyOrderDetailServiceImpl implements BcmQueryApplyOrderDetailService {

    @Autowired
    private BcmApplyCommodityOrderMapper applyCommodityOrderMapper;

    @Autowired
    private BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;

    @Autowired
    private BcmFileMapper fileMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyMapper bcmApplyCommodityOrderSupplierReplyMapper;

    @Autowired
    private BcmFlowTaskMapper bcmFlowTaskMapper;

    @Autowired
    private BcmFlowInstanceMapper bcmFlowInstanceMapper;

    /**
     * 查看详情
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryApplyOrderDetailRspBO queryApplyOrderDetail(BcmQueryApplyOrderDetailReqBO reqBO) {
        //参数验证
        verifyParam(reqBO);
        return setRspBO(reqBO);
    }

    /**
     * 出参组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryApplyOrderDetailRspBO setRspBO(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmFlowTaskBO taskBO = new BcmFlowTaskBO();
        //流程任务获取
        BcmQueryApplyOrderDetailRspBO rspBO = BcmRuUtil.success(BcmQueryApplyOrderDetailRspBO.class);
        if (!StringUtils.isEmpty(reqBO.getTaskId())) {
            taskBO = getTask(reqBO);
        }
        //获取正在审批中的流程id
        String runFlowInstId = getRunFlowInstId(reqBO.getApplyOrderId());
        //上架申请单获取
        BcmApplyOrderBO bcmApplyOrder = getBcmApplyCommodityOrder(reqBO);
        bcmApplyOrder.setTask(taskBO);
        bcmApplyOrder.setFlowInstId(runFlowInstId);
        //上架申请单明细获取
        BcmApplyOrderItemBO bcmApplyOrderItemBO = getBcmApplyCommodityOrderItem(reqBO);
        bcmApplyOrder.setApplyOrderItem(bcmApplyOrderItemBO);

        if (BcmPersonalCommodityConstant.QueryReplyFlag.YES.equals(reqBO.getQueryReplyFlag())) {
            //应答商品明细获取
            List<BcmReplyApplyOrderItemBO> replyCommodityList = getReplyCommodityList(reqBO);
            bcmApplyOrder.setReplyCommodityList(replyCommodityList);
        }
        //是否为定制商品翻译
        bcmApplyOrder.setIsCustomizedFlagStr(BcmPersonalIsCustomizedFlagEnum.getStatusDesc(bcmApplyOrder.getIsCustomizedFlag()));
        //设置当前系统时间
        bcmApplyOrder.setNowSysDate(new Date(System.currentTimeMillis()));
        rspBO.setApplyOrder(bcmApplyOrder);
        return rspBO;
    }

    /**
     * 上架申请单获取
     *
     * @param reqBO
     * @return
     */
    private BcmApplyOrderBO getBcmApplyCommodityOrder(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrder == null) {
            throw new ZTBusinessException("未查询到上架申请单");
        }
        BcmApplyOrderBO bcmApplyOrder = BcmRuUtil.js(bcmApplyCommodityOrder, BcmApplyOrderBO.class);
        bcmApplyOrder.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(bcmApplyOrder.getApplyOrderStatus()));
        bcmApplyOrder.setCancelTypeStr(BcmPersonalCommodityCancelTypeEnum.getCancelDesc(bcmApplyOrder.getCancelType()));
        bcmApplyOrder.setIsReverseAuctionFlagStr(BcmPersonalCommonStatusEnum.getStatusDesc(bcmApplyOrder.getIsReverseAuctionFlag()));
        return bcmApplyOrder;
    }

    /**
     * 上架申请单明细获取
     *
     * @param reqBO
     * @return
     */
    private BcmApplyOrderItemBO getBcmApplyCommodityOrderItem(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = applyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrderItem == null) {
            throw new ZTBusinessException("未找到上架申请单明细");
        }
        BcmApplyOrderItemBO bcmApplyOrderItemBO = BcmRuUtil.js(bcmApplyCommodityOrderItem, BcmApplyOrderItemBO.class);
        //上架申请单附件获取
        List<BcmFilePO> bcmFileList = getFileList(bcmApplyCommodityOrderItem);
        if (CollectionUtils.isNotEmpty(bcmFileList)) {
            bcmApplyOrderItemBO.setFileList(BcmCommonBeanUtil.listCopyProperties(bcmFileList, BcmFileBO.class));
        }
        return bcmApplyOrderItemBO;
    }

    /**
     * 上架申请明细单附件获取
     *
     * @param bcmApplyCommodityOrderItem
     * @return
     */
    private List<BcmFilePO> getFileList(BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem) {
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM);
        bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return fileMapper.getList(bcmQueryFilePO);
    }

    /**
     * 应答商品明细附件获取
     *
     * @return
     */
    private List<BcmFilePO> getFileList(List<Long> businessIdList) {
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessIdList(businessIdList);
        bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM);
        bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return fileMapper.getList(bcmQueryFilePO);
    }


    /**
     * 应答商品明细获取
     *
     * @param reqBO
     * @return
     */
    private List<BcmReplyApplyOrderItemBO> getReplyCommodityList(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmQueryApplyCommodityOrderSupplierReplyItemPO bcmQueryApplyCommodityOrderSupplierReplyItemPO = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        //只查询已选中
        if (BcmPersonalCommodityConstant.SelectFlag.YES.equals(reqBO.getSelectFlag())) {
            bcmQueryApplyCommodityOrderSupplierReplyItemPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
        }
        if (BooleanFlagEnum.YES.getFlag().equals(reqBO.getPlaceOrderFlag())) {
            bcmQueryApplyCommodityOrderSupplierReplyItemPO.setPlaceOrderFlag(reqBO.getPlaceOrderFlag());
        }
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        List<BcmApplyCommodityOrderSupplierReplyItemPO> bcmApplyCommodityOrderSupplierReplyItemPOS = bcmApplyCommodityOrderSupplierReplyItemMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyItemPO);
        if (CollectionUtils.isNotEmpty(bcmApplyCommodityOrderSupplierReplyItemPOS)) {

            List<BcmReplyApplyOrderItemBO> replyCommodityList = new ArrayList<>(bcmApplyCommodityOrderSupplierReplyItemPOS.size());
            List<Long> replyItemIdList = bcmApplyCommodityOrderSupplierReplyItemPOS.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyItemId).collect(Collectors.toList());
            //应答商品明细附件获取
            List<BcmFilePO> filePOS = getFileList(replyItemIdList);
            //应答单Map获取
            Map<Long, BcmApplyCommodityOrderSupplierReplyPO> supplierReplyPOMap = getapplyCommodityOrderSupplierReplyPOMap(bcmApplyCommodityOrderSupplierReplyItemPOS);
            //应答明细相关状态翻译供应商设置
            for (BcmApplyCommodityOrderSupplierReplyItemPO po : bcmApplyCommodityOrderSupplierReplyItemPOS) {
                //当供应商id不为null时只返回该供应商的应答明细
                if (reqBO.getSupId() != null && !reqBO.getSupId().equals(supplierReplyPOMap.get(po.getReplyId()).getSupplierId())) {
                    continue;
                }
                BcmReplyApplyOrderItemBO itemBO = BcmRuUtil.js(po, BcmReplyApplyOrderItemBO.class);
                itemBO.setSelectFlagStr(BcmPersonalCommonStatusEnum.getStatusDesc(itemBO.getSelectFlag()));
                itemBO.setPushFlagStr(BcmPersonalCommonStatusEnum.getStatusDesc(itemBO.getPushFlag()));
                itemBO.setCommodityReplyType(po.getCommodityReplyTypes());
                itemBO.setCommodityReplyTypeStr(BcmPersonalCommodityReplyTypeEnum.getStatusDesc(itemBO.getCommodityReplyType()));
                itemBO.setSupplierId(supplierReplyPOMap.get(itemBO.getReplyId()).getSupplierId());
                itemBO.setSupplierName(supplierReplyPOMap.get(itemBO.getReplyId()).getSupplierName());
                replyCommodityList.add(itemBO);
            }
            //应答商品明细附件设置
            if (CollectionUtils.isNotEmpty(filePOS)) {
                Map<Long, List<BcmFilePO>> fileMap = filePOS.stream().collect(Collectors.groupingBy(BcmFilePO::getBusinessId));
                for (BcmReplyApplyOrderItemBO itemBO : replyCommodityList) {
                    itemBO.setFileInfo(BcmRuUtil.jsl(fileMap.get(itemBO.getReplyItemId()), BcmFileBO.class));
                }
            }
            return replyCommodityList;
        }
        return new ArrayList<>();
    }

    /**
     * 应答单map获取
     *
     * @param bcmApplyCommodityOrderSupplierReplyItemPOS
     */
    private Map<Long, BcmApplyCommodityOrderSupplierReplyPO> getapplyCommodityOrderSupplierReplyPOMap(List<BcmApplyCommodityOrderSupplierReplyItemPO> bcmApplyCommodityOrderSupplierReplyItemPOS) {
        Set<Long> replyIdSet = bcmApplyCommodityOrderSupplierReplyItemPOS.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyId).collect(Collectors.toSet());
        BcmQueryApplyCommodityOrderSupplierReplyPO bcmQueryApplyCommodityOrderSupplierReplyPO = new BcmQueryApplyCommodityOrderSupplierReplyPO();
        bcmQueryApplyCommodityOrderSupplierReplyPO.setReplyIdList(new ArrayList<>(replyIdSet));
        List<BcmApplyCommodityOrderSupplierReplyPO> applyCommodityOrderSupplierReplyPOList = bcmApplyCommodityOrderSupplierReplyMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyPO);
        return applyCommodityOrderSupplierReplyPOList.stream().collect(Collectors.toMap(BcmApplyCommodityOrderSupplierReplyPO::getReplyId, v -> v, (k1, k2) -> k2));
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryApplyOrderDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getApplyOrderId() == null && StringUtils.isEmpty(reqBO.getTaskId())) {
            throw new ZTBusinessException("申请单id和流程任务id不能同时为null");
        }
    }

    /**
     * 流程任务获取
     *
     * @param reqBO
     */
    private BcmFlowTaskBO getTask(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmFlowTaskPO bcmFlowTaskPO = bcmFlowTaskMapper.queryByTaskId(reqBO.getTaskId());
        if (bcmFlowTaskPO == null) {
            throw new ZTBusinessException("未查询到流程任务信息");
        }
        BcmFlowInstancePO bcmFlowInstancePO = new BcmFlowInstancePO();
        bcmFlowInstancePO.setFlowInstId(bcmFlowTaskPO.getFlowInstId());
        BcmFlowInstancePO model = bcmFlowInstanceMapper.getModel(bcmFlowInstancePO);
        if (model == null) {
            throw new ZTBusinessException("未查询到任务实例信息");
        }
        reqBO.setApplyOrderId(model.getObjId());
        return BcmRuUtil.js(bcmFlowTaskPO, BcmFlowTaskBO.class);
    }


    private String getRunFlowInstId(Long applyOrderId) {
        List<BcmFlowInstancePO> bcmFlowInstancePOS = bcmFlowInstanceMapper.queryByObjId(applyOrderId);
        if (CollectionUtil.isEmpty(bcmFlowInstancePOS)) {
            return null;
        }
        BcmFlowInstancePO flowInstancePO = bcmFlowInstancePOS.stream().filter(bcmFlowInstancePO -> BcmPersonalFlowConstant.IsFinish.NO.equals(bcmFlowInstancePO.getIsFinish())).findFirst().orElse(null);
        if (flowInstancePO == null) {
            return null;
        }
        return flowInstancePO.getFlowInstId();
    }

}
