package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryItContractTypePageListService;
import com.tydic.bcm.personal.commodity.bo.BcmITContractTypeInfoBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryItContractTypePageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryItContractTypePageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmITContractTypeMapper;
import com.tydic.bcm.personal.po.BcmITContractTypePO;
import com.tydic.bcm.personal.po.BcmQueryITContractTypePO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryItContractTypePageListServiceImpl
 * 说明 IT合同类型管理-IT合同类型列表(分页)实现
 * 时间 2023/7/20 11:54
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryItContractTypePageListServiceImpl implements BcmQueryItContractTypePageListService {

    @Autowired
    private BcmITContractTypeMapper bcmITContractTypeMapper;

    /**
     * IT合同类型列表(分页)
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryItContractTypePageListRspBO queryItContractTypePageList(BcmQueryItContractTypePageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmQueryITContractTypePO bcmQueryITContractTypePO =getBcmQueryITContractTypePO(reqBO);
        Page<BcmITContractTypePO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        //IT合同类型列表(分页)查询
        List<BcmITContractTypePO> list = bcmITContractTypeMapper.getListPage(bcmQueryITContractTypePO, page);
        return setRspBO(list,page);
    }


    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmQueryITContractTypePO getBcmQueryITContractTypePO(BcmQueryItContractTypePageListReqBO reqBO){
        BcmQueryITContractTypePO bcmQueryITContractTypePO = BcmRuUtil.js(reqBO, BcmQueryITContractTypePO.class);
        bcmQueryITContractTypePO.setOrderBy("CREATE_TIME DESC");
        bcmQueryITContractTypePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmQueryITContractTypePO;
    }

    /**
     * 出参组装
     * @param list
     * @param page
     * @return
     */
    private BcmQueryItContractTypePageListRspBO setRspBO(List<BcmITContractTypePO> list, Page<BcmITContractTypePO> page){
        BcmQueryItContractTypePageListRspBO rspBO = BcmRuUtil.success(BcmQueryItContractTypePageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRows(BcmRuUtil.jsl(list,BcmITContractTypeInfoBO.class));
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryItContractTypePageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
