package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmAddInSystemCallLogService;
import com.tydic.bcm.personal.common.bo.BcmAddInSystemCallLogReqBO;
import com.tydic.bcm.personal.common.bo.BcmAddInSystemCallLogRspBO;
import com.tydic.bcm.personal.common.bo.InSystemCallLogBO;
import com.tydic.bcm.personal.dao.InSystemCallLogMapper;
import com.tydic.bcm.personal.po.InSystemCallLogPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

@HTServiceImpl
public class BcmAddInSystemCallLogServiceImpl implements BcmAddInSystemCallLogService {

    @Autowired
    private InSystemCallLogMapper inSystemCallLogMapper;

    @Override
    public BcmAddInSystemCallLogRspBO addInSystemCallLog(BcmAddInSystemCallLogReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmAddInSystemCallLogRspBO rspBO = new BcmAddInSystemCallLogRspBO();

        Date time = new Date(System.currentTimeMillis());

        if (!CollectionUtils.isEmpty(reqBO.getLogList())) {
            List<InSystemCallLogPO> insertList = JUtil.jsl(reqBO.getLogList(), InSystemCallLogPO.class);
            for (InSystemCallLogPO each : insertList) {
                each.setId(BcmIdUtil.nextId());
                each.setCreateTime(time);
                if (each.getCallResult() == 1) {
                    each.setFailTurn(1);
                }
                insertList.add(each);
            }
            inSystemCallLogMapper.insertBatch(insertList);
        }


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void judge(BcmAddInSystemCallLogReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getLogList())) {
            for (InSystemCallLogBO each : reqBO.getLogList()) {
                if (ObjectUtil.isEmpty(each.getInterfaceName())) {
                    throw new ZTBusinessException("【interfaceName】不能为空");
                }
                if (ObjectUtil.isEmpty(each.getType())) {
                    throw new ZTBusinessException("【type】调用类型不能为空");
                }
                if (ObjectUtil.isEmpty(each.getInputResponMessage())) {
                    throw new ZTBusinessException("【inputResponMessage】落地入参不能为空");
                }
                if (ObjectUtil.isEmpty(each.getUrl())) {
                    throw new ZTBusinessException("【url】不能为空");
                }
                if (ObjectUtil.isEmpty(each.getCallResult())) {
                    throw new ZTBusinessException("【callResult】不能为空");
                }
            }
        } else {
            throw new ZTBusinessException("【logList】不能为空");
        }
    }


}
