package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.bcm.personal.common.api.BcmApproveApplyOrderService;
import com.tydic.bcm.personal.common.bo.BcmApproveApplyOrderRspBO;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/7/31 14:45
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmApproveApplyOrderServiceImpl implements BcmApproveApplyOrderService {

    private final BcmFlowInstanceMapper flowInstanceMapper;

    private final BcmFlowTaskMapper flowTaskMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public BcmApproveApplyOrderRspBO approveApplyOrder(BcmFlowInstanceBO bcmFlowInstance) {
        ParamValidateUtils.validate(bcmFlowInstance);
        BcmFlowInstancePO newflowInstance = BcmCommonBeanUtil.copyProperties(bcmFlowInstance, BcmFlowInstancePO.class);
        BcmFlowInstancePO existFlowInstance = flowInstanceMapper.queryByFlowInstanceId(newflowInstance.getFlowInstId());
        if (existFlowInstance != null) {
            newflowInstance.setId(existFlowInstance.getId());
            newflowInstance.setAuditStartTime(null);
            flowInstanceMapper.update(newflowInstance);
        } else {
            newflowInstance.setId(BcmIdUtil.nextId());
            newflowInstance.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            flowInstanceMapper.insert(newflowInstance);
        }
        if (CollectionUtil.isNotEmpty(bcmFlowInstance.getBcmFlowTaskList())) {
            List<BcmFlowTaskPO> bcmFlowTaskList = BcmCommonBeanUtil.listCopyProperties(bcmFlowInstance.getBcmFlowTaskList(), BcmFlowTaskPO.class);
            List<BcmFlowTaskPO> needSaveFlowTaskList = new ArrayList<>();
            bcmFlowTaskList.forEach(bcmFlowTaskPO -> {
                BcmFlowTaskPO queryFlowTask = flowTaskMapper.queryByTaskId(bcmFlowTaskPO.getTaskId());
                if (queryFlowTask != null) {
                    bcmFlowTaskPO.setId(queryFlowTask.getId());
                    flowTaskMapper.update(bcmFlowTaskPO);
                } else {
                    bcmFlowTaskPO.setId(BcmIdUtil.nextId());
                    bcmFlowTaskPO.setFlowInstId(bcmFlowInstance.getFlowInstId());
                    bcmFlowTaskPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                    needSaveFlowTaskList.add(bcmFlowTaskPO);
                }
            });
            if (CollectionUtil.isNotEmpty(needSaveFlowTaskList)) {
                flowTaskMapper.insertBatch(needSaveFlowTaskList);
            }
        }
        return BcmRuUtil.success(BcmApproveApplyOrderRspBO.class);
    }
}
