package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncBudgetProjectService;
import com.tydic.bcm.personal.common.bo.BcmBudgetProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBudgetProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBudgetProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题 BcmFullSyncBudgetProjectServiceImpl
 * 说明 预算项目查询-预算项目全量同步实现
 * 时间 2023/8/3 14:16
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmFullSyncBudgetProjectServiceImpl implements BcmFullSyncBudgetProjectService {

    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    /**
     * 预算项目全量同步实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmFullSyncBudgetProjectRspBO fullSyncBudgetProject(BcmFullSyncBudgetProjectReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //全量同步
        fullSync(reqBO);
        return BcmRuUtil.success(BcmFullSyncBudgetProjectRspBO.class);
    }

    /**
     * 全量同步
     *
     * @param reqBO
     */
    private void fullSync(BcmFullSyncBudgetProjectReqBO reqBO) {
        List<BcmBudgetProjectInfoPO> bcmBudgetProjectInfoPOS = BcmRuUtil.jsl(reqBO.getBudgetProjectList(), BcmBudgetProjectInfoPO.class);
        Date now = new Date();
        for (BcmBudgetProjectInfoPO po : bcmBudgetProjectInfoPOS) {
            if (po.getCreateTime() == null) {
                po.setCreateTime(now);
            }
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        }
        bcmBudgetProjectInfoMapper.insertBatch(bcmBudgetProjectInfoPOS);
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmFullSyncBudgetProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (CollectionUtils.isEmpty(reqBO.getBudgetProjectList())) {
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmBudgetProjectInfoBO bo : reqBO.getBudgetProjectList()) {
            if (StringUtils.isEmpty(bo.getProjectCode())) {
                throw new ZTBusinessException("入参项目编码不能为null");
            }
            if (StringUtils.isEmpty(bo.getProjectName())) {
                throw new ZTBusinessException("入参项目名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("入参财务机构编号不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgName())) {
                throw new ZTBusinessException("入参财务中心编码不能为null");

            }
            if (bo.getStatus() == null) {
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
