package com.tydic.bcm.personal.common.impl;

import com.tydic.bcm.personal.common.api.BcmQueryJdHisOrderService;
import com.tydic.bcm.personal.common.bo.BcmQueryJdHisOrderTableReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryJdHisOrderTableRspBO;
import com.tydic.bcm.personal.dao.BcmJdHisOrderMapper;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名： BcmQueryJdHisOrderServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2023/9/13 14:39
 */
@HTServiceImpl
public class BcmQueryJdHisOrderServiceImpl implements BcmQueryJdHisOrderService {

    @Autowired
    private BcmJdHisOrderMapper bcmJdHisOrderMapper;

    @Override
    public BcmQueryJdHisOrderTableRspBO queryJdHisOrder(BcmQueryJdHisOrderTableReqBO reqBO) {
        BcmQueryJdHisOrderTableRspBO rspBO = new BcmQueryJdHisOrderTableRspBO();
        List<String> tableNameList = bcmJdHisOrderMapper.queryJdHisOrder(reqBO.getTableNamePrefix());
        rspBO.setTableNameList(tableNameList);

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
