package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQuerySupplierBankPageListService;
import com.tydic.bcm.personal.common.bo.BcmIpmpSupplierBankBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySupplierBankPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySupplierBankPageListRspBO;
import com.tydic.bcm.personal.dao.BcmIpmpSupplierBankMapper;
import com.tydic.bcm.personal.po.BcmIpmpSupplierBankPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQuerySupplierBankPageListServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2023/9/12 10:02
 */
@HTServiceImpl
public class BcmQuerySupplierBankPageListServiceImpl implements BcmQuerySupplierBankPageListService {

    @Autowired
    private BcmIpmpSupplierBankMapper bcmIpmpSupplierBankMapper;

    @Override
    public BcmQuerySupplierBankPageListRspBO querySupplierBankPageList(BcmQuerySupplierBankPageListReqBO reqBO) {
        BcmQuerySupplierBankPageListRspBO rspBO = new BcmQuerySupplierBankPageListRspBO();
        BcmIpmpSupplierBankPO queryPO = JUtil.js(reqBO, BcmIpmpSupplierBankPO.class);
        Page<BcmIpmpSupplierBankPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());

        // 根据条件分页查询列表数据
        List<BcmIpmpSupplierBankPO> bcmIpmpSupplierBankPOS =  bcmIpmpSupplierBankMapper.getPageList(queryPO,page);

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bcmIpmpSupplierBankPOS) ?
                JSONObject.parseArray(JSONObject.toJSONString(bcmIpmpSupplierBankPOS), BcmIpmpSupplierBankBO.class) : new ArrayList<>());

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
