package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBasicProjectInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface BcmBasicProjectInfoMapper {
    /**
     * 项目基本信息查询分页
     *
     * @param po
     * @param page
     * @return
     */
    List<BcmBasicProjectInfoPO> getListPage(BcmQueryBasicProjectInfoPO po, Page<BcmBasicProjectInfoPO> page);

    /**
     * 批量插入
     *
     * @param list
     */
    void insertBatch(@Param("list") List<BcmBasicProjectInfoPO> list);

    /**
     * 批量更新
     *
     * @param list
     */
    void updateBatch(@Param("list") List<BcmBasicProjectInfoPO> list);

    /**
     * 项目基本信息列表查询
     *
     * @param po
     * @return
     */
    List<BcmBasicProjectInfoPO> getList(BcmQueryBasicProjectInfoPO po);
}