package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyExtendPO;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 财务事项申请单表;(bcm_finance_matter_apply)表数据库访问层
 *
 * @author : civism
 * @date : 2023-8-16
 */
@Mapper
public interface BcmFinanceMatterApplyMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BcmFinanceMatterApplyPO queryById(Long id);

    /**
     * 统计总行数
     *
     * @param bcmFinanceMatterApply 查询条件
     * @return 总行数
     */
    long count(BcmFinanceMatterApplyPO bcmFinanceMatterApply);

    /**
     * 新增数据
     *
     * @param bcmFinanceMatterApply 实例对象
     * @return 影响行数
     */
    int insert(BcmFinanceMatterApplyPO bcmFinanceMatterApply);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmFinanceMatterApply> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmFinanceMatterApplyPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmFinanceMatterApply> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmFinanceMatterApplyPO> entities);

    /**
     * 更新数据
     *
     * @param bcmFinanceMatterApply 实例对象
     * @return 影响行数
     */
    int update(BcmFinanceMatterApplyPO bcmFinanceMatterApply);

    int updadateBath(List<BcmFinanceMatterApplyPO> list);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);


    /**
     * 财务事项申请单列表查询（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmFinanceMatterApplyPO> queryFinanceMatterApplyPageList(BcmFinanceMatterApplyExtendPO po, Page<BcmFinanceMatterApplyPO> page);

    /**
     * 列表查询
     *
     * @param po
     * @return
     */
    List<BcmFinanceMatterApplyPO> getList(BcmFinanceMatterApplyExtendPO po);
}