package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmIpmpSupplierBankPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 类名： BcmIpmpSupplierBankMapper
 * 说明：供应商银行账号Mapper
 *
 * @author： lishiqing
 * 时间： 2023/9/11 15:12
 */
@Mapper
public interface BcmIpmpSupplierBankMapper {
    /**
     * 根据条件供应商银行账号分页查询列表数据
     * @param po 参数对象
     * @param page 分页参数
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmIpmpSupplierBankPO> getPageList(BcmIpmpSupplierBankPO po, Page<BcmIpmpSupplierBankPO> page);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmIpmpSupplierBankPO set, @Param("where") BcmIpmpSupplierBankPO where);

    /**
     * 根据条件供应商银行账号查询列表数据
     * @param po 参数对象
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmIpmpSupplierBankPO> getList(BcmIpmpSupplierBankPO po);

    /**
     * 根据条件查询单条数据
     * @param po
     * @return
     */
    BcmIpmpSupplierBankPO getModelBy(BcmIpmpSupplierBankPO po);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmIpmpSupplierBankPO> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmIpmpSupplierBankPO> entities);
}
